/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.net;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.items.ItemTrackBlueprint;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import cam72cam.immersiverailroading.util.BufferUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRailUpdatePacket
implements IMessage {
    private int slot;
    private int length;
    private int quarters;
    private TrackItems type;
    private double gauge;
    private TrackPositionType posType;
    private ItemStack bedStack;
    private ItemStack railBedFill;
    private boolean isPreview;
    private BlockPos tilePreviewPos;

    public ItemRailUpdatePacket() {
    }

    @SideOnly(value=Side.CLIENT)
    public ItemRailUpdatePacket(int slot, int length, int quarters, TrackItems type, double gauge, TrackPositionType posType, ItemStack bedStack, ItemStack railBedFill, boolean isPreview) {
        this.slot = slot;
        this.length = length;
        this.quarters = quarters;
        this.type = type;
        this.posType = posType;
        this.bedStack = bedStack;
        this.railBedFill = railBedFill;
        this.isPreview = isPreview;
        this.gauge = gauge;
    }

    public ItemRailUpdatePacket(BlockPos tilePreviewPos, int length, int quarters, TrackItems type, double gauge, TrackPositionType posType, ItemStack bedStack, ItemStack railBedFill, boolean isPreview) {
        this.tilePreviewPos = tilePreviewPos;
        this.length = length;
        this.quarters = quarters;
        this.type = type;
        this.posType = posType;
        this.bedStack = bedStack;
        this.railBedFill = railBedFill;
        this.isPreview = isPreview;
        this.gauge = gauge;
    }

    public void fromBytes(ByteBuf buf) {
        this.length = buf.readInt();
        if (buf.readBoolean()) {
            this.slot = buf.readInt();
        } else {
            this.tilePreviewPos = new BlockPos(BufferUtil.readVec3i(buf));
        }
        this.quarters = buf.readInt();
        this.type = TrackItems.values()[buf.readInt()];
        this.gauge = buf.readDouble();
        this.posType = TrackPositionType.values()[buf.readInt()];
        this.bedStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.railBedFill = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.isPreview = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.length);
        buf.writeBoolean(this.tilePreviewPos == null);
        if (this.tilePreviewPos == null) {
            buf.writeInt(this.slot);
        } else {
            BufferUtil.writeVec3i(buf, (Vec3i)this.tilePreviewPos);
        }
        buf.writeInt(this.quarters);
        buf.writeInt(this.type.ordinal());
        buf.writeDouble(this.gauge);
        buf.writeInt(this.posType.ordinal());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.bedStack);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.railBedFill);
        buf.writeBoolean(this.isPreview);
    }

    public static class Handler
    implements IMessageHandler<ItemRailUpdatePacket, IMessage> {
        public IMessage onMessage(ItemRailUpdatePacket message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(ItemRailUpdatePacket message, MessageContext ctx) {
            ItemStack stack;
            TileRailPreview te = null;
            if (message.tilePreviewPos == null) {
                stack = ctx.getServerHandler().field_147369_b.field_71071_by.func_70301_a(message.slot);
            } else {
                te = TileRailPreview.get((IBlockAccess)ctx.getServerHandler().field_147369_b.field_70170_p, message.tilePreviewPos);
                if (te == null) {
                    ImmersiveRailroading.warn("Got invalid item rail update packet at %s", message.tilePreviewPos);
                    return;
                }
                stack = te.getItem();
            }
            ItemTrackBlueprint.setType(stack, message.type);
            ItemGauge.set(stack, Gauge.from(message.gauge));
            ItemTrackBlueprint.setLength(stack, message.length);
            ItemTrackBlueprint.setQuarters(stack, message.quarters);
            ItemTrackBlueprint.setPosType(stack, message.posType);
            ItemTrackBlueprint.setBed(stack, message.bedStack);
            ItemTrackBlueprint.setBedFill(stack, message.railBedFill);
            ItemTrackBlueprint.setPreview(stack, message.isPreview);
            if (message.tilePreviewPos == null) {
                ctx.getServerHandler().field_147369_b.field_71071_by.func_70299_a(message.slot, stack);
            } else {
                te.setItem(stack);
            }
        }
    }
}

