/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.net;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.physics.TickPos;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MRSSyncPacket
implements IMessage {
    private int dimension;
    private int entityID;
    private List<TickPos> positions;

    public MRSSyncPacket() {
    }

    public MRSSyncPacket(EntityMoveableRollingStock mrs, List<TickPos> positions) {
        this.dimension = mrs.field_71093_bK;
        this.entityID = mrs.func_145782_y();
        this.positions = positions;
    }

    public void applyTo(EntityMoveableRollingStock mrs) {
        mrs.handleTickPosPacket(this.positions);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.entityID);
        buf.writeInt(this.positions.size());
        for (TickPos pos : this.positions) {
            pos.write(buf);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.entityID = buf.readInt();
        this.positions = new ArrayList<TickPos>();
        for (int numPositions = buf.readInt(); numPositions > 0; --numPositions) {
            TickPos pos = new TickPos();
            pos.read(buf);
            this.positions.add(pos);
        }
    }

    public static class Handler
    implements IMessageHandler<MRSSyncPacket, IMessage> {
        public IMessage onMessage(MRSSyncPacket message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(MRSSyncPacket message, MessageContext ctx) {
            EntityMoveableRollingStock entity = (EntityMoveableRollingStock)ImmersiveRailroading.proxy.getWorld(message.dimension).func_73045_a(message.entityID);
            if (entity == null) {
                return;
            }
            message.applyTo(entity);
        }
    }
}

