/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.net;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.util.BufferUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MultiblockSelectCraftPacket
implements IMessage {
    private ItemStack selected;
    private BlockPos tilePreviewPos;

    public MultiblockSelectCraftPacket() {
    }

    public MultiblockSelectCraftPacket(BlockPos tilePreviewPos, ItemStack selected) {
        this.tilePreviewPos = tilePreviewPos;
        this.selected = selected;
    }

    public void fromBytes(ByteBuf buf) {
        this.tilePreviewPos = new BlockPos(BufferUtil.readVec3i(buf));
        this.selected = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        BufferUtil.writeVec3i(buf, (Vec3i)this.tilePreviewPos);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.selected);
    }

    public static class Handler
    implements IMessageHandler<MultiblockSelectCraftPacket, IMessage> {
        public IMessage onMessage(MultiblockSelectCraftPacket message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(MultiblockSelectCraftPacket message, MessageContext ctx) {
            TileMultiblock tile = TileMultiblock.get((IBlockAccess)ctx.getServerHandler().field_147369_b.field_70170_p, message.tilePreviewPos);
            if (tile == null) {
                ImmersiveRailroading.warn("Got invalid craft update packet at %s", message.tilePreviewPos);
                return;
            }
            tile.setCraftItem(message.selected);
        }
    }
}

