/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.net;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityRidableRollingStock;
import cam72cam.immersiverailroading.util.BufferUtil;
import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PassengerPositionsPacket
implements IMessage {
    private int dimension;
    private UUID stockID;
    private Map<UUID, Vec3d> passengerPositions;

    public PassengerPositionsPacket() {
    }

    public PassengerPositionsPacket(EntityRidableRollingStock stock) {
        this.dimension = stock.func_130014_f_().field_73011_w.getDimension();
        this.stockID = stock.getPersistentID();
        this.passengerPositions = stock.passengerPositions;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.stockID = BufferUtil.readUUID(buf);
        this.passengerPositions = BufferUtil.readPlayerPositions(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        BufferUtil.writeUUID(buf, this.stockID);
        BufferUtil.writePlayerPositions(buf, this.passengerPositions);
    }

    public static class Handler
    implements IMessageHandler<PassengerPositionsPacket, IMessage> {
        public IMessage onMessage(PassengerPositionsPacket message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(final PassengerPositionsPacket message, MessageContext ctx) {
            List matches = ImmersiveRailroading.proxy.getWorld(message.dimension).func_175644_a(EntityRidableRollingStock.class, (Predicate)new Predicate<EntityRidableRollingStock>(){

                public boolean apply(@Nullable EntityRidableRollingStock entity) {
                    return entity != null && entity.getPersistentID().equals(message.stockID);
                }
            });
            if (matches.size() != 1) {
                return;
            }
            EntityRidableRollingStock entity = (EntityRidableRollingStock)((Object)matches.get(0));
            entity.passengerPositions = message.passengerPositions;
        }
    }
}

