/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.physics;

import cam72cam.immersiverailroading.physics.TickPos;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.immersiverailroading.util.VecUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import trackapi.lib.ITrackTile;
import trackapi.lib.Util;

public class MovementSimulator {
    private World world;
    private TickPos position;
    private float bogeyFrontOffset;
    private float bogeyRearOffset;
    private double gauge;

    public MovementSimulator(World world, TickPos startPos, float bogeyFrontOffset, float bogeyRearOffset, double gauge) {
        this.world = world;
        this.position = startPos.clone();
        this.bogeyFrontOffset = bogeyFrontOffset;
        this.bogeyRearOffset = bogeyRearOffset;
        this.gauge = gauge;
    }

    public TickPos nextPosition(double moveDistance) {
        ++this.position.tickID;
        this.position.isOffTrack = false;
        TickPos origPosition = this.position.clone();
        if (Math.abs(moveDistance) < 0.001) {
            this.position.speed = Speed.ZERO;
            return this.position;
        }
        this.position.speed = Speed.fromMinecraft(moveDistance);
        boolean isReverse = moveDistance < 0.0;
        Vec3d front = this.frontBogeyPosition();
        Vec3d rear = this.rearBogeyPosition();
        if (isReverse) {
            moveDistance = -moveDistance;
            this.position.frontYaw += 180.0f;
            this.position.rearYaw += 180.0f;
            this.position.rotationYaw += 180.0f;
            this.position.rotationYaw = (this.position.rotationYaw + 360.0f) % 360.0f;
            this.position.frontYaw = (this.position.frontYaw + 360.0f) % 360.0f;
            this.position.rearYaw = (this.position.rearYaw + 360.0f) % 360.0f;
        }
        Vec3d nextFront = this.nextPosition(front, this.position.rotationYaw, this.position.frontYaw, moveDistance);
        Vec3d nextRear = this.nextPosition(rear, this.position.rotationYaw, this.position.rearYaw, moveDistance);
        if (nextFront.equals((Object)front) || nextRear == rear) {
            origPosition.speed = Speed.ZERO;
            if (this.position.isOffTrack) {
                origPosition.isOffTrack = true;
            }
            return origPosition;
        }
        Vec3d frontDelta = front.func_72444_a(nextFront);
        Vec3d rearDelta = rear.func_72444_a(nextRear);
        this.position.frontYaw = VecUtil.toYaw(frontDelta);
        this.position.rearYaw = VecUtil.toYaw(rearDelta);
        Vec3d currCenter = VecUtil.between(front, rear);
        Vec3d nextCenter = VecUtil.between(nextFront, nextRear);
        Vec3d deltaCenter = currCenter.func_72444_a(nextCenter);
        Vec3d bogeySkew = nextRear.func_72444_a(nextFront);
        this.position.rotationYaw = VecUtil.toYaw(bogeySkew);
        this.position.rotationPitch = (float)Math.toDegrees(MathHelper.func_181159_b((double)bogeySkew.field_72448_b, (double)nextRear.func_72438_d(nextFront)));
        if (isReverse) {
            this.position.frontYaw += 180.0f;
            this.position.rearYaw += 180.0f;
            this.position.rotationYaw = (this.position.rotationYaw + 360.0f) % 360.0f;
            this.position.frontYaw = (this.position.frontYaw + 360.0f) % 360.0f;
            this.position.rearYaw = (this.position.rearYaw + 360.0f) % 360.0f;
        }
        this.position.position = this.position.position.func_178787_e(deltaCenter);
        if (this.world.func_175623_d(new BlockPos(this.position.position))) {
            this.position.position = this.position.position.func_72441_c(0.0, -0.1, 0.0);
        }
        return this.position;
    }

    private ITrackTile findTrack(Vec3d currentPosition, float trainYaw) {
        ITrackTile te = Util.getTileEntity((World)this.world, (Vec3d)currentPosition, (boolean)true);
        if (te != null && te.getTrackGauge() == this.gauge) {
            return te;
        }
        te = Util.getTileEntity((World)this.world, (Vec3d)currentPosition.func_178787_e(VecUtil.fromYaw(-1.0, trainYaw)), (boolean)true);
        if (te != null && te.getTrackGauge() == this.gauge) {
            return te;
        }
        te = Util.getTileEntity((World)this.world, (Vec3d)currentPosition.func_178787_e(VecUtil.fromYaw(1.0, trainYaw)), (boolean)true);
        if (te != null && te.getTrackGauge() == this.gauge) {
            return te;
        }
        return null;
    }

    public Vec3d nextPosition(Vec3d currentPosition, float rotationYaw, float bogeyYaw, double distance) {
        ITrackTile rail = this.findTrack(currentPosition, rotationYaw);
        if (rail == null) {
            this.position.isOffTrack = true;
            return currentPosition;
        }
        Vec3d result = rail.getNextPosition(currentPosition, VecUtil.fromYaw(distance, rotationYaw));
        if (result == null) {
            this.position.isOffTrack = true;
            return currentPosition;
        }
        return result;
    }

    public Vec3d frontBogeyPosition() {
        return VecUtil.fromYawPitch(this.bogeyFrontOffset, this.position.rotationYaw, this.position.rotationPitch).func_178787_e(this.position.position);
    }

    public Vec3d rearBogeyPosition() {
        return VecUtil.fromYawPitch(this.bogeyRearOffset, this.position.rotationYaw, this.position.rotationPitch).func_178787_e(this.position.position);
    }
}

