/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.physics;

import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.VecUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MovementTrack {
    private static TileRailBase directRailFromPosition(World world, Vec3d position) {
        return TileRailBase.get((IBlockAccess)world, new BlockPos((int)Math.floor(position.field_72450_a), (int)Math.floor(position.field_72448_b), (int)Math.floor(position.field_72449_c)));
    }

    public static Vec3d nextPosition(World world, Vec3d currentPosition, TileRail rail, float trainYaw, double distanceMeters) {
        Vec3d delta = VecUtil.fromYaw(distanceMeters, trainYaw);
        if (rail == null) {
            if (!world.field_72995_K) {
                return null;
            }
            return currentPosition.func_178787_e(delta);
        }
        double distance = delta.func_72433_c();
        if (rail.getType().isTurn()) {
            Vec3d posDelta = rail.getCenter().func_72444_a(currentPosition);
            double posRelYaw = MathHelper.func_181159_b((double)posDelta.field_72450_a, (double)(-posDelta.field_72449_c));
            double radius = rail.getRadius() - 0.5;
            double yawDelt = distance / radius;
            Vec3d nextPos = currentPosition.func_178787_e(delta);
            Vec3d newpos = rail.getCenter().func_72441_c(Math.sin(posRelYaw + yawDelt) * radius, 0.0, -Math.cos(posRelYaw + yawDelt) * radius);
            Vec3d newneg = rail.getCenter().func_72441_c(Math.sin(posRelYaw - yawDelt) * radius, 0.0, -Math.cos(posRelYaw - yawDelt) * radius);
            if (newpos.func_178788_d(nextPos).func_72433_c() < newneg.func_178788_d(nextPos).func_72433_c()) {
                return newpos;
            }
            return newneg;
        }
        if (rail.getType() == TrackItems.CROSSING) {
            delta = VecUtil.fromYaw(distance, EnumFacing.func_176733_a((double)trainYaw).func_185119_l());
            return currentPosition.func_178787_e(delta);
        }
        delta = VecUtil.fromYaw(distance, trainYaw);
        float angle = (float)rail.getRotationQuarter() / 4.0f * 90.0f + rail.getFacing().func_185119_l();
        Vec3d center = rail.getPlacementPosition();
        double toCenter = center.func_72438_d(currentPosition);
        Vec3d possiblePositive = center.func_178787_e(VecUtil.fromYaw(toCenter, angle));
        Vec3d possibleNegative = center.func_178787_e(VecUtil.fromYaw(-toCenter, angle));
        double angularDistance = 0.0;
        angularDistance = possiblePositive.func_72438_d(currentPosition) < possibleNegative.func_72438_d(currentPosition) ? toCenter : -toCenter;
        possiblePositive = center.func_178787_e(VecUtil.fromYaw(angularDistance + distance, angle));
        possibleNegative = center.func_178787_e(VecUtil.fromYaw(angularDistance - distance, angle));
        Vec3d outPosition = possiblePositive.func_72438_d(currentPosition.func_178787_e(delta)) < possibleNegative.func_72438_d(currentPosition.func_178787_e(delta)) ? possiblePositive : possibleNegative;
        TileRailBase directRail = MovementTrack.directRailFromPosition(world, outPosition);
        outPosition = directRail != null ? new Vec3d(outPosition.field_72450_a, (double)((float)directRail.func_174877_v().func_177956_o() + directRail.getHeight()), outPosition.field_72449_c) : new Vec3d(outPosition.field_72450_a, currentPosition.field_72448_b, outPosition.field_72449_c);
        return outPosition;
    }
}

