/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.physics;

import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.physics.TickPos;
import cam72cam.immersiverailroading.util.Speed;

public class PhysicsAccummulator {
    double tractiveEffortNewtons = 0.0;
    double airBrake = 0.0;
    double rollingResistanceNewtons = 0.0;
    double gradeForceNewtons = 0.0;
    double massToMoveKg = 0.0;
    Speed speed;

    public PhysicsAccummulator(Speed speed) {
        this.speed = speed;
    }

    public void accumulate(EntityRollingStock stock, Boolean direction) {
        this.massToMoveKg += stock.getWeight();
        if (!(stock instanceof EntityMoveableRollingStock)) {
            return;
        }
        EntityMoveableRollingStock movable = (EntityMoveableRollingStock)stock;
        TickPos latest = movable.positions.get(movable.positions.size() - 1);
        double stockMassLb = 2.20462 * stock.getWeight();
        this.rollingResistanceNewtons += 0.0015 * stockMassLb * (double)4.44822f;
        double grade = -Math.tan(Math.toRadians(latest.rotationPitch % 90.0f));
        this.gradeForceNewtons += stockMassLb / 100.0 * (grade * 100.0) * (double)4.44822f;
        if (stock instanceof Locomotive) {
            Locomotive loco = (Locomotive)stock;
            this.tractiveEffortNewtons += loco.getTractiveEffortNewtons(this.speed) * (double)(direction != false ? 1 : -1);
            this.airBrake += (double)loco.getAirBrake();
        }
        int slowdown = movable.getSpeedRetarderSlowdown(latest);
        this.rollingResistanceNewtons += (double)slowdown * stockMassLb / 300.0;
    }

    public Speed getVelocity() {
        double brakeAdhesion = this.massToMoveKg * 0.25;
        double airBrakeNewtons = brakeAdhesion * Math.min(this.airBrake, 1.0) * (double)4.44822f;
        double tractiveAccell = this.tractiveEffortNewtons / this.massToMoveKg;
        double resistanceAccell = this.rollingResistanceNewtons / this.massToMoveKg;
        double gradeAccell = this.gradeForceNewtons / this.massToMoveKg;
        double brakeAccell = airBrakeNewtons / this.massToMoveKg;
        double currentMCVelocity = this.speed.minecraft();
        double deltaAccellTractiveMCVelocity = Speed.fromMetric(tractiveAccell).minecraft();
        double deltaAccellGradeMCVelocity = Speed.fromMetric(gradeAccell).minecraft();
        double deltaAccellRollingResistanceMCVelocity = Speed.fromMetric(resistanceAccell).minecraft();
        double deltaAccellBrakeMCVelocity = Speed.fromMetric(brakeAccell).minecraft();
        double deltaDecell = -1.0 * Math.copySign(Math.min(Math.abs(currentMCVelocity), deltaAccellRollingResistanceMCVelocity + deltaAccellBrakeMCVelocity), currentMCVelocity);
        double newMCVelocity = currentMCVelocity + deltaAccellTractiveMCVelocity + deltaAccellGradeMCVelocity + deltaDecell;
        if (Math.abs(newMCVelocity) < 0.001) {
            newMCVelocity = 0.0;
        }
        return Speed.fromMinecraft(newMCVelocity);
    }
}

