/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.proxy;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.blocks.BlockRailBase;
import cam72cam.immersiverailroading.entity.CarFreight;
import cam72cam.immersiverailroading.entity.EntityRidableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.gui.CastingGUI;
import cam72cam.immersiverailroading.gui.FreightContainer;
import cam72cam.immersiverailroading.gui.FreightContainerGui;
import cam72cam.immersiverailroading.gui.PlateRollerGUI;
import cam72cam.immersiverailroading.gui.SteamHammerContainer;
import cam72cam.immersiverailroading.gui.SteamHammerContainerGui;
import cam72cam.immersiverailroading.gui.SteamLocomotiveContainer;
import cam72cam.immersiverailroading.gui.SteamLocomotiveContainerGui;
import cam72cam.immersiverailroading.gui.TankContainer;
import cam72cam.immersiverailroading.gui.TankContainerGui;
import cam72cam.immersiverailroading.gui.TenderContainer;
import cam72cam.immersiverailroading.gui.TenderContainerGui;
import cam72cam.immersiverailroading.gui.TrackGui;
import cam72cam.immersiverailroading.gui.overlay.DieselLocomotiveOverlay;
import cam72cam.immersiverailroading.gui.overlay.SteamLocomotiveOverlay;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.net.KeyPressPacket;
import cam72cam.immersiverailroading.net.MousePressPacket;
import cam72cam.immersiverailroading.proxy.ClientResourceReloadListener;
import cam72cam.immersiverailroading.proxy.CommonProxy;
import cam72cam.immersiverailroading.render.PlateItemModel;
import cam72cam.immersiverailroading.render.RailAugmentItemModel;
import cam72cam.immersiverailroading.render.RailBaseModel;
import cam72cam.immersiverailroading.render.RailCastItemRender;
import cam72cam.immersiverailroading.render.RailItemRender;
import cam72cam.immersiverailroading.render.StockEntityRender;
import cam72cam.immersiverailroading.render.StockItemComponentModel;
import cam72cam.immersiverailroading.render.StockItemModel;
import cam72cam.immersiverailroading.render.TileMultiblockRender;
import cam72cam.immersiverailroading.render.TrackBlueprintItemModel;
import cam72cam.immersiverailroading.render.rail.RailRenderUtil;
import cam72cam.immersiverailroading.render.rail.TileRailPreviewRender;
import cam72cam.immersiverailroading.render.rail.TileRailRender;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import cam72cam.immersiverailroading.util.GLBoolTracker;
import cam72cam.immersiverailroading.util.RailInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GLContext;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static Map<KeyTypes, KeyBinding> keys = new HashMap<KeyTypes, KeyBinding>();
    public static final IRenderFactory<EntityRollingStock> RENDER_INSTANCE = new IRenderFactory<EntityRollingStock>(){

        public Render<? super EntityRollingStock> createRenderFor(RenderManager manager) {
            return new StockEntityRender(manager);
        }
    };
    private static int tickCount = 0;
    private static double skew = 1.0;
    private static double offsetAggregator = 0.0;
    private static double offsetCount = 0.0;

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int entityIDorPosX, int posY, int posZ) {
        System.out.println((Object)GuiTypes.values()[ID]);
        switch (GuiTypes.values()[ID]) {
            case FREIGHT: {
                return new FreightContainerGui((CarFreight)world.func_73045_a(entityIDorPosX), new FreightContainer((IInventory)player.field_71071_by, (CarFreight)world.func_73045_a(entityIDorPosX)));
            }
            case TANK: 
            case DIESEL_LOCOMOTIVE: {
                return new TankContainerGui((FreightTank)world.func_73045_a(entityIDorPosX), new TankContainer((IInventory)player.field_71071_by, (FreightTank)world.func_73045_a(entityIDorPosX)));
            }
            case TENDER: {
                return new TenderContainerGui((Tender)world.func_73045_a(entityIDorPosX), new TenderContainer((IInventory)player.field_71071_by, (Tender)world.func_73045_a(entityIDorPosX)));
            }
            case STEAM_LOCOMOTIVE: {
                return new SteamLocomotiveContainerGui((LocomotiveSteam)world.func_73045_a(entityIDorPosX), new SteamLocomotiveContainer((IInventory)player.field_71071_by, (LocomotiveSteam)world.func_73045_a(entityIDorPosX)));
            }
            case RAIL: {
                return new TrackGui();
            }
            case RAIL_PREVIEW: {
                return new TrackGui(world, entityIDorPosX, posY, posZ);
            }
            case STEAM_HAMMER: {
                TileMultiblock te = TileMultiblock.get((IBlockAccess)world, new BlockPos(entityIDorPosX, posY, posZ));
                if (te == null || !te.isLoaded()) {
                    return null;
                }
                return new SteamHammerContainerGui(new SteamHammerContainer((IInventory)player.field_71071_by, te));
            }
            case PLATE_ROLLER: {
                TileMultiblock te = TileMultiblock.get((IBlockAccess)world, new BlockPos(entityIDorPosX, posY, posZ));
                if (te == null || !te.isLoaded()) {
                    return null;
                }
                return new PlateRollerGUI(te);
            }
            case CASTING: {
                TileMultiblock te = TileMultiblock.get((IBlockAccess)world, new BlockPos(entityIDorPosX, posY, posZ));
                if (te == null || !te.isLoaded()) {
                    return null;
                }
                return new CastingGUI(te);
            }
        }
        return null;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        keys.put(KeyTypes.THROTTLE_UP, new KeyBinding("Increase Throttle", 72, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.THROTTLE_ZERO, new KeyBinding("Zero Throttle", 76, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.THROTTLE_DOWN, new KeyBinding("Decrease Throttle", 80, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.AIR_BRAKE_UP, new KeyBinding("Increase Air Brake", 71, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.AIR_BRAKE_ZERO, new KeyBinding("Zero Air Brake", 75, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.AIR_BRAKE_DOWN, new KeyBinding("Decrease Air Brake", 79, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.HORN, new KeyBinding("Sound Horn", 156, "key.categories.immersiverailroading"));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.THROTTLE_UP));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.THROTTLE_DOWN));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.THROTTLE_ZERO));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.AIR_BRAKE_UP));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.AIR_BRAKE_DOWN));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.AIR_BRAKE_ZERO));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.HORN));
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new ClientResourceReloadListener());
    }

    @Override
    public World getWorld(int dimension) {
        return FMLClientHandler.instance().getWorldClient();
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        for (Class type : entityClasses) {
            RenderingRegistry.registerEntityRenderingHandler((Class)type, RENDER_INSTANCE);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        OBJLoader.INSTANCE.addDomain("immersiverailroading".toLowerCase());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRail.class, (TileEntitySpecialRenderer)new TileRailRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRailPreview.class, (TileEntitySpecialRenderer)new TileRailPreviewRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMultiblock.class, (TileEntitySpecialRenderer)new TileMultiblockRender());
        ModelLoader.setCustomModelResourceLocation((Item)ImmersiveRailroading.ITEM_LARGE_WRENCH, (int)0, (ModelResourceLocation)new ModelResourceLocation(ImmersiveRailroading.ITEM_LARGE_WRENCH.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)ImmersiveRailroading.ITEM_HOOK, (int)0, (ModelResourceLocation)new ModelResourceLocation(ImmersiveRailroading.ITEM_HOOK.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)ImmersiveRailroading.ITEM_RAIL_BLOCK, (int)0, (ModelResourceLocation)new ModelResourceLocation(ImmersiveRailroading.ITEM_RAIL_BLOCK.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)ImmersiveRailroading.ITEM_ROLLING_STOCK_COMPONENT, (int)0, (ModelResourceLocation)new ModelResourceLocation(ImmersiveRailroading.ITEM_ROLLING_STOCK_COMPONENT.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)ImmersiveRailroading.ITEM_ROLLING_STOCK, (int)0, (ModelResourceLocation)new ModelResourceLocation(ImmersiveRailroading.ITEM_ROLLING_STOCK.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)ImmersiveRailroading.ITEM_AUGMENT, (int)0, (ModelResourceLocation)new ModelResourceLocation(ImmersiveRailroading.ITEM_AUGMENT.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)ImmersiveRailroading.ITEM_RAIL, (int)0, (ModelResourceLocation)new ModelResourceLocation(ImmersiveRailroading.ITEM_RAIL.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)ImmersiveRailroading.ITEM_CAST_RAIL, (int)0, (ModelResourceLocation)new ModelResourceLocation(ImmersiveRailroading.ITEM_CAST_RAIL.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)ImmersiveRailroading.ITEM_PLATE, (int)0, (ModelResourceLocation)new ModelResourceLocation(ImmersiveRailroading.ITEM_PLATE.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)ImmersiveRailroading.ITEM_MANUAL, (int)0, (ModelResourceLocation)new ModelResourceLocation("minecraft:written_book", ""));
    }

    @SubscribeEvent
    public static void onModelBakeEvent(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(ImmersiveRailroading.ITEM_ROLLING_STOCK.getRegistryName(), ""), (Object)new StockItemModel());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(ImmersiveRailroading.ITEM_RAIL_BLOCK.getRegistryName(), ""), (Object)new TrackBlueprintItemModel());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(ImmersiveRailroading.ITEM_ROLLING_STOCK_COMPONENT.getRegistryName(), ""), (Object)new StockItemComponentModel());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(ImmersiveRailroading.ITEM_AUGMENT.getRegistryName(), ""), (Object)new RailAugmentItemModel());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(ImmersiveRailroading.ITEM_RAIL.getRegistryName(), ""), (Object)new RailItemRender());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(ImmersiveRailroading.ITEM_CAST_RAIL.getRegistryName(), ""), (Object)new RailCastItemRender());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(ImmersiveRailroading.ITEM_PLATE.getRegistryName(), ""), (Object)new PlateItemModel());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(ImmersiveRailroading.BLOCK_RAIL.getRegistryName(), ""), (Object)new RailBaseModel());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(ImmersiveRailroading.BLOCK_RAIL_GAG.getRegistryName(), ""), (Object)new RailBaseModel());
    }

    @SubscribeEvent
    public static void onKeyInput(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (!player.func_184218_aH()) {
            return;
        }
        if (!(player.func_184187_bx() instanceof EntityRidableRollingStock)) {
            return;
        }
        EntityRidableRollingStock riding = (EntityRidableRollingStock)player.func_184187_bx();
        for (KeyTypes key : keys.keySet()) {
            KeyBinding binding = keys.get((Object)key);
            if (!binding.func_151470_d()) continue;
            ImmersiveRailroading.net.sendToServer((IMessage)new KeyPressPacket(key, riding.func_130014_f_().field_73011_w.getDimension(), player.func_145782_y(), riding.func_145782_y()));
        }
        if (player.field_71158_b.field_187257_e) {
            ImmersiveRailroading.net.sendToServer((IMessage)new KeyPressPacket(KeyTypes.PLAYER_LEFT, riding.func_130014_f_().field_73011_w.getDimension(), player.func_145782_y(), riding.func_145782_y()));
        }
        if (player.field_71158_b.field_187258_f) {
            ImmersiveRailroading.net.sendToServer((IMessage)new KeyPressPacket(KeyTypes.PLAYER_RIGHT, riding.func_130014_f_().field_73011_w.getDimension(), player.func_145782_y(), riding.func_145782_y()));
        }
        if (player.field_71158_b.field_187255_c) {
            ImmersiveRailroading.net.sendToServer((IMessage)new KeyPressPacket(KeyTypes.PLAYER_FORWARD, riding.func_130014_f_().field_73011_w.getDimension(), player.func_145782_y(), riding.func_145782_y()));
        }
        if (player.field_71158_b.field_187256_d) {
            ImmersiveRailroading.net.sendToServer((IMessage)new KeyPressPacket(KeyTypes.PLAYER_BACKWARD, riding.func_130014_f_().field_73011_w.getDimension(), player.func_145782_y(), riding.func_145782_y()));
        }
    }

    @SubscribeEvent
    public static void onClick(MouseEvent event) {
        if ((event.getButton() == 0 || event.getButton() == 1) && event.isButtonstate()) {
            if (Minecraft.func_71410_x().field_71476_x == null) {
                return;
            }
            Entity entity = Minecraft.func_71410_x().field_71476_x.field_72308_g;
            if (entity != null && entity instanceof EntityRidableRollingStock) {
                ImmersiveRailroading.net.sendToServer((IMessage)new MousePressPacket(event.getButton(), entity.field_70170_p.field_73011_w.getDimension(), entity.func_145782_y()));
                event.setCanceled(true);
                return;
            }
            Entity riding = Minecraft.func_71410_x().field_71439_g.func_184187_bx();
            if (riding != null && riding instanceof EntityRidableRollingStock) {
                ImmersiveRailroading.net.sendToServer((IMessage)new MousePressPacket(event.getButton(), riding.field_70170_p.field_73011_w.getDimension(), riding.func_145782_y()));
                event.setCanceled(true);
                return;
            }
        }
    }

    @Override
    public InputStream getResourceStream(ResourceLocation modelLoc) throws IOException {
        return Minecraft.func_71410_x().func_110442_L().func_110536_a(modelLoc).func_110527_b();
    }

    @Override
    public List<InputStream> getResourceStreamAll(ResourceLocation modelLoc) throws IOException {
        ArrayList<InputStream> res = new ArrayList<InputStream>();
        for (IResource resource : Minecraft.func_71410_x().func_110442_L().func_135056_b(modelLoc)) {
            res.add(resource.func_110527_b());
        }
        return res;
    }

    @SubscribeEvent
    public static void onOverlayEvent(RenderGameOverlayEvent.Text event) {
        Entity riding;
        if (!Minecraft.func_71410_x().field_71474_y.field_74330_P || (riding = Minecraft.func_71410_x().field_71439_g.func_184187_bx()) instanceof Locomotive) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onHackRenderEvent(RenderWorldLastEvent event) {
        Entity toRender;
        if (Minecraft.func_71410_x().field_71439_g.func_184218_aH() && (toRender = Minecraft.func_71410_x().field_71439_g.func_184208_bv()) instanceof EntityRollingStock) {
            GLBoolTracker color = new GLBoolTracker(2903, true);
            RenderHelper.func_74519_b();
            Minecraft.func_71410_x().func_175598_ae().func_188388_a(toRender, event.getPartialTicks(), true);
            RenderHelper.func_74518_a();
            color.restore();
        }
    }

    @SubscribeEvent
    public static void onOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CHAT) {
            new SteamLocomotiveOverlay().draw();
            new DieselLocomotiveOverlay().draw();
        }
    }

    @SubscribeEvent
    public static void onRenderMouseover(DrawBlockHighlightEvent event) {
        if (event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && event.getPlayer().func_184614_ca().func_77973_b() == ImmersiveRailroading.ITEM_RAIL_BLOCK) {
            EntityPlayer player = event.getPlayer();
            ItemStack stack = event.getPlayer().func_184614_ca();
            BlockPos pos = event.getTarget().func_178782_a();
            Vec3d vec = event.getTarget().field_72307_f;
            float hitX = (float)(vec.field_72450_a - (double)pos.func_177958_n());
            float hitY = (float)(vec.field_72448_b - (double)pos.func_177956_o());
            float hitZ = (float)(vec.field_72449_c - (double)pos.func_177952_p());
            if (player.func_130014_f_().func_180495_p(pos).func_177230_c() instanceof BlockRailBase) {
                pos = pos.func_177977_b();
            }
            pos = pos.func_177984_a();
            RailInfo info = new RailInfo(stack, player.field_70170_p, player.field_70177_z, pos, hitX, hitY, hitZ);
            GL11.glPushMatrix();
            GLBoolTracker blend = new GLBoolTracker(3042, true);
            GL11.glBlendFunc((int)32771, (int)1);
            if (GLContext.getCapabilities().OpenGL14) {
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
            double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            GL11.glTranslated((double)(-d0), (double)(-d1), (double)(-d2));
            GL11.glTranslated((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            RailRenderUtil.render(info, true);
            blend.restore();
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (offsetCount != 0.0 && ++tickCount > 40) {
            tickCount = 0;
            double tickOffset = offsetAggregator / offsetCount;
            if (tickOffset > 0.0) {
                skew *= 1.0 - Math.min(10.0, tickOffset) / 20.0;
            }
            if (tickOffset < 0.0) {
                skew *= 1.0 + Math.min(10.0, -tickOffset) / 20.0;
            }
            offsetCount = 0.0;
            offsetAggregator = 0.0;
        }
    }

    @Override
    public void addTickMetric(double tickPosOffset) {
        offsetCount += 1.0;
        offsetAggregator += tickPosOffset;
    }

    @Override
    public double serverTicksPerClientTick() {
        return skew;
    }
}

