/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.proxy;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.blocks.BlockRailBase;
import cam72cam.immersiverailroading.blocks.BlockRailPreview;
import cam72cam.immersiverailroading.entity.CarFreight;
import cam72cam.immersiverailroading.entity.CarPassenger;
import cam72cam.immersiverailroading.entity.CarTank;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.gui.FreightContainer;
import cam72cam.immersiverailroading.gui.SteamHammerContainer;
import cam72cam.immersiverailroading.gui.SteamLocomotiveContainer;
import cam72cam.immersiverailroading.gui.TankContainer;
import cam72cam.immersiverailroading.gui.TenderContainer;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.multiblock.BoilerRollerMultiblock;
import cam72cam.immersiverailroading.multiblock.CastingMultiblock;
import cam72cam.immersiverailroading.multiblock.MultiblockRegistry;
import cam72cam.immersiverailroading.multiblock.PlateRollerMultiblock;
import cam72cam.immersiverailroading.multiblock.RailRollerMultiblock;
import cam72cam.immersiverailroading.multiblock.SteamHammerMultiblock;
import cam72cam.immersiverailroading.net.BuildableStockSyncPacket;
import cam72cam.immersiverailroading.net.ItemRailUpdatePacket;
import cam72cam.immersiverailroading.net.KeyPressPacket;
import cam72cam.immersiverailroading.net.MRSSyncPacket;
import cam72cam.immersiverailroading.net.MousePressPacket;
import cam72cam.immersiverailroading.net.MultiblockSelectCraftPacket;
import cam72cam.immersiverailroading.net.PassengerPositionsPacket;
import cam72cam.immersiverailroading.proxy.ChunkManager;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailGag;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="immersiverailroading")
public abstract class CommonProxy
implements IGuiHandler {
    protected static List<Class<? extends EntityRollingStock>> entityClasses = new ArrayList<Class<? extends EntityRollingStock>>();
    protected String configDir;

    public void preInit(FMLPreInitializationEvent event) throws IOException {
        this.configDir = event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "immersiverailroading";
        DefinitionManager.initDefinitions();
        OreDictionary.registerOre((String)"railBed", (Block)Blocks.field_150336_V);
        OreDictionary.registerOre((String)"railBed", (Block)Blocks.field_150347_e);
        OreDictionary.registerOre((String)"railBed", (ItemStack)new ItemStack(Blocks.field_192443_dR, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"railBed", (Block)Blocks.field_150346_d);
        OreDictionary.registerOre((String)"railBed", (Block)Blocks.field_150351_n);
        OreDictionary.registerOre((String)"railBed", (ItemStack)new ItemStack(Blocks.field_150405_ch, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"railBed", (ItemStack)new ItemStack(Blocks.field_150364_r, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"railBed", (ItemStack)new ItemStack(Blocks.field_150363_s, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"railBed", (Block)Blocks.field_150385_bj);
        OreDictionary.registerOre((String)"railBed", (ItemStack)new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE));
        MultiblockRegistry.register("STEAM_HAMMER", new SteamHammerMultiblock());
        MultiblockRegistry.register("PLATE_MACHINE", new PlateRollerMultiblock());
        MultiblockRegistry.register("RAIL_MACHINE", new RailRollerMultiblock());
        MultiblockRegistry.register("BOILER_MACHINE", new BoilerRollerMultiblock());
        MultiblockRegistry.register("CASTING", new CastingMultiblock());
    }

    public void init(FMLInitializationEvent event) {
        ImmersiveRailroading.net.registerMessage(MRSSyncPacket.Handler.class, MRSSyncPacket.class, 0, Side.CLIENT);
        ImmersiveRailroading.net.registerMessage(KeyPressPacket.Handler.class, KeyPressPacket.class, 1, Side.SERVER);
        ImmersiveRailroading.net.registerMessage(PassengerPositionsPacket.Handler.class, PassengerPositionsPacket.class, 2, Side.CLIENT);
        ImmersiveRailroading.net.registerMessage(MousePressPacket.Handler.class, MousePressPacket.class, 6, Side.SERVER);
        ImmersiveRailroading.net.registerMessage(ItemRailUpdatePacket.Handler.class, ItemRailUpdatePacket.class, 7, Side.SERVER);
        ImmersiveRailroading.net.registerMessage(BuildableStockSyncPacket.Handler.class, BuildableStockSyncPacket.class, 8, Side.CLIENT);
        ImmersiveRailroading.net.registerMessage(MultiblockSelectCraftPacket.Handler.class, MultiblockSelectCraftPacket.class, 9, Side.SERVER);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ImmersiveRailroading.instance, (IGuiHandler)this);
    }

    public void serverStarting(FMLServerStartingEvent event) {
    }

    public abstract World getWorld(int var1);

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.BLOCK_RAIL_GAG);
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.BLOCK_RAIL);
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.BLOCK_RAIL_PREVIEW);
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.BLOCK_MULTIBLOCK);
        GameRegistry.registerTileEntity(TileRailGag.class, (String)"block_rail_gag");
        GameRegistry.registerTileEntity(TileRail.class, (String)"block_rail");
        GameRegistry.registerTileEntity(TileRailPreview.class, (String)"block_rail_preview");
        GameRegistry.registerTileEntity(TileMultiblock.class, (String)"multiblock");
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.ITEM_RAIL_BLOCK);
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.ITEM_ROLLING_STOCK);
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.ITEM_ROLLING_STOCK_COMPONENT);
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.ITEM_LARGE_WRENCH);
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.ITEM_HOOK);
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.ITEM_AUGMENT);
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.ITEM_MANUAL);
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.ITEM_RAIL);
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.ITEM_PLATE);
        event.getRegistry().register((IForgeRegistryEntry)ImmersiveRailroading.ITEM_CAST_RAIL);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        int lastEntityID = 0;
        for (Class<? extends EntityRollingStock> type : entityClasses) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("immersiverailroading", type.getSimpleName()), type, (String)type.getSimpleName(), (int)(++lastEntityID), (Object)ImmersiveRailroading.instance, (int)512, (int)20, (boolean)false);
        }
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (!BlockRailBase.tryBreakRail((IBlockAccess)event.getWorld(), event.getPos())) {
            event.setCanceled(true);
        } else if (BlockRailPreview.tryBreakPreview(event.getWorld(), event.getPos(), event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        ChunkManager.handleWorldTick(event.world);
    }

    public abstract InputStream getResourceStream(ResourceLocation var1) throws IOException;

    public abstract List<InputStream> getResourceStreamAll(ResourceLocation var1) throws IOException;

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int entityIDorX, int y, int z) {
        switch (GuiTypes.values()[ID]) {
            case FREIGHT: {
                return new FreightContainer((IInventory)player.field_71071_by, (CarFreight)world.func_73045_a(entityIDorX));
            }
            case TANK: 
            case DIESEL_LOCOMOTIVE: {
                return new TankContainer((IInventory)player.field_71071_by, (FreightTank)world.func_73045_a(entityIDorX));
            }
            case TENDER: {
                return new TenderContainer((IInventory)player.field_71071_by, (Tender)world.func_73045_a(entityIDorX));
            }
            case STEAM_LOCOMOTIVE: {
                return new SteamLocomotiveContainer((IInventory)player.field_71071_by, (LocomotiveSteam)world.func_73045_a(entityIDorX));
            }
            case STEAM_HAMMER: {
                TileMultiblock te = TileMultiblock.get((IBlockAccess)world, new BlockPos(entityIDorX, y, z));
                if (te == null) {
                    return null;
                }
                return new SteamHammerContainer((IInventory)player.field_71071_by, te);
            }
        }
        return null;
    }

    public void addTickMetric(double tickPosOffset) {
    }

    public double serverTicksPerClientTick() {
        return 1.0;
    }

    static {
        entityClasses.add(LocomotiveSteam.class);
        entityClasses.add(LocomotiveDiesel.class);
        entityClasses.add(CarPassenger.class);
        entityClasses.add(CarFreight.class);
        entityClasses.add(CarTank.class);
        entityClasses.add(Tender.class);
    }
}

