/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.proxy;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.proxy.CommonProxy;
import cam72cam.immersiverailroading.proxy.ReloadResourcesCommand;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.server.FMLServerHandler;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(value={Side.SERVER})
public class ServerProxy
extends CommonProxy {
    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new ReloadResourcesCommand());
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int entityID, int nop1, int nop2) {
        return null;
    }

    @Override
    public World getWorld(int dimension) {
        return FMLServerHandler.instance().getServer().func_71218_a(dimension);
    }

    private String pathString(ResourceLocation location, boolean startingSlash) {
        return (startingSlash ? "/" : "") + "assets/" + location.func_110624_b() + "/" + location.func_110623_a();
    }

    private InputStream getEmbeddedResourceStream(ResourceLocation location) throws IOException {
        URL url = ImmersiveRailroading.class.getResource(this.pathString(location, true));
        return url != null ? ImmersiveRailroading.class.getResourceAsStream(this.pathString(location, true)) : null;
    }

    private List<InputStream> getFileResourceStreams(ResourceLocation location) throws IOException {
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        File folder = new File(this.configDir);
        if (folder.exists()) {
            if (folder.isDirectory()) {
                File[] files;
                for (File file : files = folder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".zip");
                    }
                })) {
                    ZipFile resourcePack = new ZipFile(file);
                    ZipEntry entry = resourcePack.getEntry(this.pathString(location, false));
                    if (entry != null) {
                        InputStream stream = resourcePack.getInputStream(entry);
                        streams.add(new ByteArrayInputStream(IOUtils.toByteArray((InputStream)stream)));
                    }
                    resourcePack.close();
                }
            } else {
                ImmersiveRailroading.error("Expecting " + this.configDir + " to be a directory", new Object[0]);
            }
        } else {
            folder.mkdirs();
        }
        return streams;
    }

    @Override
    public InputStream getResourceStream(ResourceLocation location) throws IOException {
        List<InputStream> res = this.getResourceStreamAll(location);
        if (res.size() > 0) {
            return res.get(0);
        }
        return null;
    }

    @Override
    public List<InputStream> getResourceStreamAll(ResourceLocation location) throws IOException {
        List<InputStream> res = this.getFileResourceStreams(location);
        InputStream stream = this.getEmbeddedResourceStream(location);
        if (stream != null) {
            res.add(stream);
        }
        return res;
    }
}

