/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.entity.CarFreight;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class CarFreightDefinition
extends EntityRollingStockDefinition {
    private int numSlots;
    private int width;
    private List<String> validCargo;

    public CarFreightDefinition(String defID, JsonObject data) throws Exception {
        super(defID, data);
        if (this.validCargo == null) {
            this.validCargo = new ArrayList<String>();
        }
    }

    @Override
    public void parseJson(JsonObject data) throws Exception {
        super.parseJson(data);
        JsonObject freight = data.get("freight").getAsJsonObject();
        this.numSlots = freight.get("slots").getAsInt();
        this.width = freight.get("width").getAsInt();
        this.validCargo = new ArrayList<String>();
        for (JsonElement el : freight.get("cargo").getAsJsonArray()) {
            this.validCargo.add(el.getAsString());
        }
    }

    @Override
    public EntityRollingStock instance(World world) {
        return new CarFreight(world, this.defID);
    }

    public int getInventorySize(Gauge gauge) {
        return MathHelper.func_76143_f((double)((double)this.numSlots * gauge.scale()));
    }

    public int getInventoryWidth(Gauge gauge) {
        return MathHelper.func_76143_f((double)((double)this.width * gauge.scale()));
    }
}

