/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.registry.CarFreightDefinition;
import cam72cam.immersiverailroading.registry.CarPassengerDefinition;
import cam72cam.immersiverailroading.registry.CarTankDefinition;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDieselDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveSteamDefinition;
import cam72cam.immersiverailroading.registry.TenderDefinition;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class DefinitionManager {
    private static Map<String, EntityRollingStockDefinition> definitions;

    public static void initDefinitions() throws IOException {
        definitions = new LinkedHashMap<String, EntityRollingStockDefinition>();
        ResourceLocation resource = new ResourceLocation("immersiverailroading", "rolling_stock/stock.json");
        List<InputStream> inputs = ImmersiveRailroading.proxy.getResourceStreamAll(resource);
        for (InputStream input : inputs) {
            JsonObject data;
            String defID;
            JsonParser parser = new JsonParser();
            JsonObject stock = parser.parse((Reader)new InputStreamReader(input)).getAsJsonObject();
            block19: for (JsonElement locomotive : stock.get("locomotives").getAsJsonArray()) {
                try {
                    defID = "rolling_stock/locomotives/" + locomotive.getAsString() + ".json";
                    data = DefinitionManager.getJsonData(defID);
                    String era = data.get("era").getAsString();
                    LocomotiveDefinition loco = null;
                    switch (era) {
                        case "steam": {
                            loco = new LocomotiveSteamDefinition(defID, data);
                            break;
                        }
                        case "diesel": {
                            loco = new LocomotiveDieselDefinition(defID, data);
                            break;
                        }
                        default: {
                            ImmersiveRailroading.warn("Invalid era %s in %s", era, defID);
                            continue block19;
                        }
                    }
                    definitions.put(defID, loco);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            for (JsonElement tender : stock.get("tender").getAsJsonArray()) {
                try {
                    defID = "rolling_stock/tender/" + tender.getAsString() + ".json";
                    data = DefinitionManager.getJsonData(defID);
                    definitions.put(defID, new TenderDefinition(defID, data));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            for (JsonElement passenger_car : stock.get("passenger").getAsJsonArray()) {
                try {
                    defID = "rolling_stock/passenger/" + passenger_car.getAsString() + ".json";
                    data = DefinitionManager.getJsonData(defID);
                    definitions.put(defID, new CarPassengerDefinition(defID, data));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            for (JsonElement freight_car : stock.get("freight").getAsJsonArray()) {
                try {
                    defID = "rolling_stock/freight/" + freight_car.getAsString() + ".json";
                    data = DefinitionManager.getJsonData(defID);
                    definitions.put(defID, new CarFreightDefinition(defID, data));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            for (JsonElement tank_car : stock.get("tank").getAsJsonArray()) {
                try {
                    defID = "rolling_stock/tank/" + tank_car.getAsString() + ".json";
                    data = DefinitionManager.getJsonData(defID);
                    definitions.put(defID, new CarTankDefinition(defID, data));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static JsonObject getJsonData(String defID) throws IOException {
        ImmersiveRailroading.info("Loading stock " + defID, new Object[0]);
        ResourceLocation resource = new ResourceLocation("immersiverailroading", defID);
        InputStream input = ImmersiveRailroading.proxy.getResourceStream(resource);
        JsonParser parser = new JsonParser();
        JsonObject result = parser.parse((Reader)new InputStreamReader(input)).getAsJsonObject();
        return result;
    }

    public static EntityRollingStockDefinition getDefinition(String defID) {
        EntityRollingStockDefinition val = definitions.get(defID);
        if (val == null) {
            ImmersiveRailroading.warn("Invalid stock ID: " + defID, new Object[0]);
        }
        return val;
    }

    public static Collection<EntityRollingStockDefinition> getDefinitions() {
        return definitions.values();
    }

    public static Set<String> getDefinitionNames() {
        return definitions.keySet();
    }
}

