/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.util.RealBB;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityRollingStockDefinition {
    protected String defID;
    public String name = "Unknown";
    private OBJModel model;
    private Vec3d passengerCenter = new Vec3d(0.0, 0.0, 0.0);
    private float bogeyFront;
    private float bogeyRear;
    public double frontBounds;
    private double rearBounds;
    private double heightBounds;
    private double widthBounds;
    private double passengerCompartmentLength;
    private double passengerCompartmentWidth;
    private int weight;
    private int maxPassengers;
    private Map<RenderComponentType, List<RenderComponent>> renderComponents;
    ArrayList<ItemComponentType> itemComponents;
    List<Vec3d> blocksInBounds = null;

    public EntityRollingStock instance(World world) {
        return null;
    }

    public final EntityRollingStock spawn(World world, Vec3d pos, EnumFacing facing, Gauge gauge) {
        EntityRollingStock stock = this.instance(world);
        stock.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        stock.field_70126_B = facing.func_185119_l();
        stock.field_70177_z = facing.func_185119_l();
        stock.gauge = gauge;
        world.func_72838_d((Entity)stock);
        return stock;
    }

    public EntityRollingStockDefinition(String defID, JsonObject data) throws Exception {
        this.defID = defID;
        if (data == null) {
            this.renderComponents = new HashMap<RenderComponentType, List<RenderComponent>>();
            this.itemComponents = new ArrayList();
            return;
        }
        this.parseJson(data);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.REMAINING, this, this.parseComponents()), true);
    }

    public void parseJson(JsonObject data) throws Exception {
        this.name = data.get("name").getAsString();
        float darken = 0.0f;
        if (data.has("darken_model")) {
            darken = data.get("darken_model").getAsFloat();
        }
        this.model = new OBJModel(new ResourceLocation(data.get("model").getAsString()), darken);
        JsonObject passenger = data.get("passenger").getAsJsonObject();
        this.passengerCenter = new Vec3d(passenger.get("center_x").getAsDouble(), passenger.get("center_y").getAsDouble(), 0.0);
        this.passengerCompartmentLength = passenger.get("length").getAsDouble();
        this.passengerCompartmentWidth = passenger.get("width").getAsDouble();
        this.maxPassengers = passenger.get("slots").getAsInt();
        this.bogeyFront = data.get("trucks").getAsJsonObject().get("front").getAsFloat();
        this.bogeyRear = data.get("trucks").getAsJsonObject().get("rear").getAsFloat();
        this.frontBounds = -this.model.minOfGroup(this.model.groups()).field_72450_a;
        this.rearBounds = this.model.maxOfGroup(this.model.groups()).field_72450_a;
        this.widthBounds = this.model.widthOfGroups(this.model.groups());
        this.heightBounds = this.model.heightOfGroups(this.model.groups());
        this.weight = data.get("properties").getAsJsonObject().get("weight_kg").getAsInt();
    }

    protected void addComponentIfExists(RenderComponent renderComponent, boolean itemComponent) {
        if (renderComponent != null) {
            if (!this.renderComponents.containsKey((Object)renderComponent.type)) {
                this.renderComponents.put(renderComponent.type, new ArrayList());
            }
            this.renderComponents.get((Object)renderComponent.type).add(renderComponent);
            if (itemComponent && renderComponent.type != RenderComponentType.REMAINING) {
                this.itemComponents.add(ItemComponentType.from(renderComponent.type));
            }
        }
    }

    protected boolean unifiedBogies() {
        return true;
    }

    protected Set<String> parseComponents() {
        this.renderComponents = new HashMap<RenderComponentType, List<RenderComponent>>();
        this.itemComponents = new ArrayList();
        HashSet<String> groups = new HashSet<String>();
        groups.addAll(this.model.groups());
        for (int i = 0; i < 10; ++i) {
            if (this.unifiedBogies()) {
                this.addComponentIfExists(RenderComponent.parsePosID(RenderComponentType.BOGEY_POS_WHEEL_X, this, groups, "FRONT", i), true);
                this.addComponentIfExists(RenderComponent.parsePosID(RenderComponentType.BOGEY_POS_WHEEL_X, this, groups, "REAR", i), true);
            } else {
                this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.BOGEY_FRONT_WHEEL_X, this, groups, i), true);
                this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.BOGEY_REAR_WHEEL_X, this, groups, i), true);
            }
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.FRAME_WHEEL_X, this, groups, i), true);
        }
        if (this.unifiedBogies()) {
            this.addComponentIfExists(RenderComponent.parsePos(RenderComponentType.BOGEY_POS, this, groups, "FRONT"), true);
            this.addComponentIfExists(RenderComponent.parsePos(RenderComponentType.BOGEY_POS, this, groups, "REAR"), true);
        } else {
            this.addComponentIfExists(RenderComponent.parse(RenderComponentType.BOGEY_FRONT, this, groups), true);
            this.addComponentIfExists(RenderComponent.parse(RenderComponentType.BOGEY_REAR, this, groups), true);
        }
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.FRAME, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.SHELL, this, groups), true);
        return groups;
    }

    public RenderComponent getComponent(RenderComponentType name, Gauge gauge) {
        if (!this.renderComponents.containsKey((Object)name)) {
            return null;
        }
        return this.renderComponents.get((Object)name).get(0).scale(gauge);
    }

    public RenderComponent getComponent(RenderComponentType name, String pos, Gauge gauge) {
        if (!this.renderComponents.containsKey((Object)name)) {
            return null;
        }
        for (RenderComponent c : this.renderComponents.get((Object)name)) {
            if (c.pos.equals(pos)) {
                return c.scale(gauge);
            }
            if (!c.side.equals(pos)) continue;
            return c.scale(gauge);
        }
        return null;
    }

    public RenderComponent getComponent(RenderComponent comp, Gauge gauge) {
        if (!this.renderComponents.containsKey((Object)comp.type)) {
            return null;
        }
        for (RenderComponent c : this.getComponents(comp.type, gauge)) {
            if (!c.equals(comp)) continue;
            return c;
        }
        return null;
    }

    public List<RenderComponent> getComponents(RenderComponentType name, Gauge gauge) {
        if (!this.renderComponents.containsKey((Object)name)) {
            return null;
        }
        ArrayList<RenderComponent> components = new ArrayList<RenderComponent>();
        for (RenderComponent c : this.renderComponents.get((Object)name)) {
            components.add(c.scale(gauge));
        }
        return components;
    }

    public List<RenderComponent> getComponents(RenderComponentType name, String pos, Gauge gauge) {
        if (!this.renderComponents.containsKey((Object)name)) {
            return null;
        }
        ArrayList<RenderComponent> components = new ArrayList<RenderComponent>();
        for (RenderComponent c : this.renderComponents.get((Object)name)) {
            if (!c.pos.equals(pos)) continue;
            components.add(c.scale(gauge));
        }
        return components;
    }

    public Vec3d getPassengerCenter(Gauge gauge) {
        return this.passengerCenter.func_186678_a(gauge.scale());
    }

    public Vec3d correctPassengerBounds(Gauge gauge, Vec3d pos) {
        double gs = gauge.scale();
        if (pos.field_72450_a > this.passengerCompartmentLength * gs) {
            pos = new Vec3d(this.passengerCompartmentLength * gs, pos.field_72448_b, pos.field_72449_c);
        }
        if (pos.field_72450_a < -this.passengerCompartmentLength * gs) {
            pos = new Vec3d(-this.passengerCompartmentLength * gs, pos.field_72448_b, pos.field_72449_c);
        }
        if (Math.abs(pos.field_72449_c) > this.passengerCompartmentWidth / 2.0 * gs) {
            pos = new Vec3d(pos.field_72450_a, pos.field_72448_b, Math.copySign(this.passengerCompartmentWidth / 2.0 * gs, pos.field_72449_c));
        }
        return pos;
    }

    public boolean isAtFront(Gauge gauge, Vec3d pos) {
        return pos.field_72450_a >= this.passengerCompartmentLength * gauge.scale();
    }

    public boolean isAtRear(Gauge gauge, Vec3d pos) {
        return pos.field_72450_a <= -this.passengerCompartmentLength * gauge.scale();
    }

    public List<ItemComponentType> getItemComponents() {
        return this.itemComponents;
    }

    public float getBogeyFront(Gauge gauge) {
        return (float)gauge.scale() * this.bogeyFront;
    }

    public float getBogeyRear(Gauge gauge) {
        return (float)gauge.scale() * this.bogeyRear;
    }

    public double getCouplerPosition(EntityCoupleableRollingStock.CouplerType coupler, Gauge gauge) {
        switch (coupler) {
            case FRONT: {
                return gauge.scale() * (this.frontBounds + Config.couplerRange);
            }
            case BACK: {
                return gauge.scale() * (this.rearBounds + Config.couplerRange);
            }
        }
        return 0.0;
    }

    public AxisAlignedBB getBounds(EntityMoveableRollingStock stock, Gauge gauge) {
        return new RealBB(gauge.scale() * this.frontBounds, gauge.scale() * -this.rearBounds, gauge.scale() * this.widthBounds, gauge.scale() * this.heightBounds, stock.field_70177_z).func_191194_a(stock.func_174791_d());
    }

    public List<Vec3d> getBlocksInBounds(Gauge gauge) {
        if (this.blocksInBounds == null) {
            this.blocksInBounds = new ArrayList<Vec3d>();
            double minX = gauge.scale() * -this.rearBounds;
            double maxX = gauge.scale() * this.frontBounds;
            double minY = gauge.scale() * 0.0;
            double maxY = gauge.scale() * this.heightBounds;
            double minZ = gauge.scale() * -this.widthBounds / 2.0;
            double maxZ = gauge.scale() * this.widthBounds / 2.0;
            for (double x = minX; x <= maxX; x += 1.0) {
                for (double y = minY; y <= maxY; y += 1.0) {
                    for (double z = minZ; z <= maxZ; z += 1.0) {
                        this.blocksInBounds.add(new Vec3d(x, y, z));
                    }
                }
            }
        }
        return this.blocksInBounds;
    }

    public List<String> getTooltip(Gauge gauge) {
        ArrayList<String> tips = new ArrayList<String>();
        return tips;
    }

    public double getPassengerCompartmentWidth(Gauge gauge) {
        return gauge.scale() * this.passengerCompartmentWidth;
    }

    public OBJModel getModel() {
        return this.model;
    }

    public int getWeight(Gauge gauge) {
        return (int)(gauge.scale() * (double)this.weight);
    }

    public double getHeight(Gauge gauge) {
        return gauge.scale() * this.heightBounds;
    }

    public double getLength(Gauge gauge) {
        return gauge.scale() * this.frontBounds + this.rearBounds;
    }

    public int getMaxPassengers() {
        return this.maxPassengers;
    }
}

