/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.util.Speed;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;

public class LocomotiveDefinition
extends EntityRollingStockDefinition {
    private String works;
    private int power;
    private int traction;
    private Speed maxSpeed;

    public LocomotiveDefinition(String defID, JsonObject data) throws Exception {
        super(defID, data);
        if (this.works == null) {
            this.works = "Unknown";
        }
        if (this.maxSpeed == null) {
            this.maxSpeed = Speed.ZERO;
        }
    }

    @Override
    public void parseJson(JsonObject data) throws Exception {
        super.parseJson(data);
        this.works = data.get("works").getAsString();
        JsonObject properties = data.get("properties").getAsJsonObject();
        this.power = properties.get("horsepower").getAsInt();
        this.traction = properties.get("tractive_effort_lbf").getAsInt();
        this.maxSpeed = Speed.fromMetric(properties.get("max_speed_kmh").getAsDouble());
    }

    @Override
    protected Set<String> parseComponents() {
        Set<String> groups = super.parseComponents();
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.CAB, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.BELL, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.WHISTLE, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.HORN, this, groups), true);
        return groups;
    }

    @Override
    public List<String> getTooltip(Gauge gauge) {
        List<String> tips = super.getTooltip(gauge);
        tips.add(GuiText.LOCO_WORKS.toString(this.works));
        tips.add(GuiText.LOCO_HORSE_POWER.toString(this.getHorsePower(gauge)));
        tips.add(GuiText.LOCO_MAX_SPEED.toString(this.getMaxSpeed(gauge).metricString()));
        return tips;
    }

    public int getHorsePower(Gauge gauge) {
        return (int)(gauge.scale() * (double)this.power);
    }

    public int getStartingTractionNewtons(Gauge gauge) {
        return (int)(gauge.scale() * (double)this.traction * 4.44822);
    }

    public Speed getMaxSpeed(Gauge gauge) {
        return Speed.fromMinecraft(gauge.scale() * this.maxSpeed.minecraft());
    }
}

