/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.util.FluidQuantity;
import com.google.gson.JsonObject;
import java.util.Set;
import net.minecraft.world.World;

public class LocomotiveDieselDefinition
extends LocomotiveDefinition {
    private FluidQuantity fuelCapacity;
    private int fuelEfficiency;

    public LocomotiveDieselDefinition(String defID, JsonObject data) throws Exception {
        super(defID, data);
        if (this.fuelCapacity == null) {
            this.fuelCapacity = FluidQuantity.ZERO;
        }
    }

    @Override
    protected Set<String> parseComponents() {
        Set<String> groups = super.parseComponents();
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.FUEL_TANK, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.ALTERNATOR, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.ENGINE_BLOCK, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.CRANKSHAFT, this, groups), true);
        for (int i = 0; i < 20; ++i) {
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.PISTON_X, this, groups, i), true);
        }
        return groups;
    }

    @Override
    public void parseJson(JsonObject data) throws Exception {
        super.parseJson(data);
        JsonObject properties = data.get("properties").getAsJsonObject();
        this.fuelCapacity = FluidQuantity.FromLiters(properties.get("fuel_capacity_l").getAsInt());
        this.fuelEfficiency = properties.get("fuel_efficiency_%").getAsInt();
    }

    @Override
    public EntityRollingStock instance(World world) {
        return new LocomotiveDiesel(world, this.defID);
    }

    public FluidQuantity getFuelCapacity(Gauge gauge) {
        return this.fuelCapacity.scale(gauge.scale()).min(FluidQuantity.FromBuckets(1));
    }

    public int getFuelEfficiency() {
        return this.fuelEfficiency;
    }
}

