/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.registry.CarTankDefinition;
import com.google.gson.JsonObject;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TenderDefinition
extends CarTankDefinition {
    private int numSlots;
    private int width;

    public TenderDefinition(String defID, JsonObject data) throws Exception {
        super(defID, data);
    }

    @Override
    public void parseJson(JsonObject data) throws Exception {
        super.parseJson(data);
        JsonObject tender = data.get("tender").getAsJsonObject();
        this.numSlots = tender.get("slots").getAsInt();
        this.width = tender.get("width").getAsInt();
    }

    @Override
    public EntityRollingStock instance(World world) {
        return new Tender(world, this.defID);
    }

    public int getInventorySize(Gauge gauge) {
        return MathHelper.func_76143_f((double)((double)this.numSlots * gauge.scale()));
    }

    public int getInventoryWidth(Gauge gauge) {
        return MathHelper.func_76143_f((double)((double)this.width * gauge.scale()));
    }
}

