/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.model.obj.Face;
import cam72cam.immersiverailroading.model.obj.Material;
import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.model.obj.Vec2f;
import cam72cam.immersiverailroading.render.OBJTextureSheet;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class OBJRender {
    public OBJModel model;
    private OBJTextureSheet texture;
    private int prevTexture = -1;
    private Integer displayList = null;
    public Map<Double, Map<Iterable<String>, Integer>> displayLists = new HashMap<Double, Map<Iterable<String>, Integer>>();

    public OBJRender(OBJModel model) {
        this.model = model;
        this.texture = new OBJTextureSheet(model);
    }

    public boolean hasTexture() {
        return this.texture.mappings.size() != 0;
    }

    public void bindTexture() {
        int currentTexture;
        if (this.hasTexture() && (currentTexture = GL11.glGetInteger((int)32873)) != this.texture.textureID) {
            this.prevTexture = currentTexture;
            GL11.glBindTexture((int)3553, (int)this.texture.textureID);
        }
    }

    public void restoreTexture() {
        if (this.hasTexture() && this.prevTexture != -1) {
            GL11.glBindTexture((int)3553, (int)this.prevTexture);
            this.prevTexture = -1;
        }
    }

    public void draw() {
        if (this.displayList == null) {
            this.displayList = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.displayList, (int)4864);
            this.drawDirect();
            GL11.glEndList();
        }
        GL11.glCallList((int)this.displayList);
    }

    public void drawDirect() {
        this.drawDirectGroups(this.model.groups.keySet());
    }

    public void drawGroups(Iterable<String> groupNames, double scale) {
        if (!this.displayLists.containsKey(scale)) {
            this.displayLists.put(scale, new HashMap());
        }
        if (!this.displayLists.get(scale).containsKey(groupNames)) {
            int groupsDisplayList = GL11.glGenLists((int)1);
            GL11.glNewList((int)groupsDisplayList, (int)4864);
            this.drawDirectGroups(groupNames, scale);
            GL11.glEndList();
            this.displayLists.get(scale).put(groupNames, groupsDisplayList);
        }
        GL11.glCallList((int)this.displayLists.get(scale).get(groupNames));
    }

    public void drawGroups(Iterable<String> groupNames) {
        this.drawGroups(groupNames, 1.0);
    }

    public void drawDirectGroups(Iterable<String> groupNames) {
        this.drawDirectGroups(groupNames, 1.0);
    }

    public void drawDirectGroups(Iterable<String> groupNames, double scale) {
        ArrayList quads = new ArrayList();
        boolean has_vn = true;
        for (String group : groupNames) {
            quads.addAll(this.model.groups.get(group));
        }
        FloatBuffer vertexBuffer = BufferUtils.createFloatBuffer((int)(quads.size() * 4 * 3));
        FloatBuffer normalBuffer = BufferUtils.createFloatBuffer((int)(quads.size() * 4 * 3));
        FloatBuffer colorBuffer = BufferUtils.createFloatBuffer((int)(quads.size() * 4 * 4));
        FloatBuffer texBuffer = BufferUtils.createFloatBuffer((int)(quads.size() * 4 * 2));
        for (Face face : quads) {
            Material currentMTL = this.model.materials.get(face.mtl);
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            float a = 0.0f;
            if (currentMTL.Kd != null) {
                r = Math.max(0.0f, currentMTL.Kd.get(0) - this.model.darken);
                g = Math.max(0.0f, currentMTL.Kd.get(1) - this.model.darken);
                b = Math.max(0.0f, currentMTL.Kd.get(2) - this.model.darken);
                a = currentMTL.Kd.get(3);
            }
            for (int[] point : face.points) {
                Vec3d v = this.model.vertices.get(point[0]);
                Vec2f vt = point[1] != -1 ? this.model.vertexTextures.get(point[1]) : null;
                Vec3d vn = point[2] != -1 ? this.model.vertexNormals.get(point[2]) : null;
                vertexBuffer.put((float)(v.field_72450_a * scale));
                vertexBuffer.put((float)(v.field_72448_b * scale));
                vertexBuffer.put((float)(v.field_72449_c * scale));
                if (vn != null) {
                    normalBuffer.put((float)vn.field_72450_a);
                    normalBuffer.put((float)vn.field_72448_b);
                    normalBuffer.put((float)vn.field_72449_c);
                } else {
                    has_vn = false;
                }
                if (vt != null) {
                    texBuffer.put(this.texture.convertU(face.mtl, vt.x));
                    texBuffer.put(this.texture.convertV(face.mtl, -vt.y));
                } else {
                    texBuffer.put(this.texture.convertU(face.mtl, 0.0f));
                    texBuffer.put(this.texture.convertV(face.mtl, 0.0f));
                }
                colorBuffer.put(r);
                colorBuffer.put(g);
                colorBuffer.put(b);
                colorBuffer.put(a);
            }
        }
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glEnableClientState((int)32886);
        if (has_vn) {
            GL11.glEnableClientState((int)32885);
        }
        vertexBuffer.flip();
        colorBuffer.flip();
        normalBuffer.flip();
        texBuffer.flip();
        GL11.glTexCoordPointer((int)2, (int)8, (FloatBuffer)texBuffer);
        GL11.glColorPointer((int)4, (int)16, (FloatBuffer)colorBuffer);
        if (has_vn) {
            GL11.glNormalPointer((int)12, (FloatBuffer)normalBuffer);
        }
        GL11.glVertexPointer((int)3, (int)12, (FloatBuffer)vertexBuffer);
        GL11.glDrawArrays((int)7, (int)0, (int)(quads.size() * 4));
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32886);
        if (has_vn) {
            GL11.glDisableClientState((int)32885);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

