/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.model.obj.Face;
import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.model.obj.Vec2f;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class OBJTextureSheet {
    public Map<String, SubTexture> mappings = new HashMap<String, SubTexture>();
    private int sheetWidth = 0;
    private int sheetHeight = 0;
    public final int textureID;

    public OBJTextureSheet(OBJModel model) {
        for (String groupName : model.groups.keySet()) {
            List<Face> quads = model.groups.get(groupName);
            for (Face face : quads) {
                String mtlName = face.mtl;
                if (model.materials.get((Object)mtlName).texKd == null) continue;
                if (!this.mappings.containsKey(mtlName)) {
                    try {
                        this.mappings.put(mtlName, new SubTexture(model.materials.get((Object)mtlName).texKd));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                for (int[] point : face.points) {
                    Vec2f vt;
                    Vec2f vec2f = vt = point[1] != -1 ? model.vertexTextures.get(point[1]) : null;
                    if (vt == null) continue;
                    this.mappings.get(mtlName).extendSpace(vt);
                }
            }
        }
        int maxSize = GL11.glGetInteger((int)3379);
        int currentX = 0;
        int currentY = 0;
        int rowHeight = 0;
        for (SubTexture tex : this.mappings.values()) {
            if (currentX + tex.getAbsoluteWidth() > maxSize) {
                currentX = 0;
                currentY += rowHeight;
                rowHeight = 0;
            }
            rowHeight = Math.max(rowHeight, tex.getAbsoluteHeight());
            this.sheetWidth = Math.max(this.sheetWidth, currentX += tex.getAbsoluteWidth());
            this.sheetHeight = Math.max(this.sheetHeight, currentY += tex.getAbsoluteHeight());
        }
        this.textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)this.textureID);
        currentX = 0;
        currentY = 0;
        rowHeight = 0;
        TextureUtil.func_110991_a((int)this.textureID, (int)this.sheetWidth, (int)this.sheetHeight);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        ImmersiveRailroading.debug("Max Tex Size: %s", maxSize);
        ImmersiveRailroading.debug("Sheet Width: %s", this.sheetWidth);
        ImmersiveRailroading.debug("Sheet Height: %s", this.sheetHeight);
        for (SubTexture tex : this.mappings.values()) {
            ImmersiveRailroading.debug("%s copies %s x %s", tex.tex, tex.copiesU(), tex.copiesV());
            ImmersiveRailroading.debug("%s  actual %s x %s", tex.tex, tex.getAbsoluteWidth(), tex.getAbsoluteHeight());
            if (tex.getAbsoluteWidth() > maxSize) {
                ImmersiveRailroading.error("BAD TEXTURE FIXME", new Object[0]);
            }
            if (currentX + tex.getAbsoluteWidth() > maxSize) {
                currentX = 0;
                currentY += rowHeight;
                rowHeight = 0;
                ImmersiveRailroading.debug("NEXT_LINE", new Object[0]);
            }
            rowHeight = Math.max(rowHeight, tex.getAbsoluteHeight());
            tex.upload(this.textureID, currentX, currentY, this.sheetWidth, this.sheetHeight);
            currentX += tex.getAbsoluteWidth();
            currentY += tex.getAbsoluteHeight();
        }
    }

    public float convertU(String mtlName, float u) {
        if (this.mappings.containsKey(mtlName)) {
            return this.mappings.get(mtlName).convertU(u);
        }
        return 0.0f;
    }

    public float convertV(String mtlName, float v) {
        if (this.mappings.containsKey(mtlName)) {
            return this.mappings.get(mtlName).convertV(v);
        }
        return 0.0f;
    }

    private class SubTexture {
        private int realWidth;
        private int realHeight;
        private int sheetWidth;
        private int sheetHeight;
        private int originX;
        private int originY;
        private int minU = 0;
        private int minV = 0;
        private int maxU = 1;
        private int maxV = 1;
        public ResourceLocation tex;
        private BufferedImage image;

        SubTexture(ResourceLocation tex) throws IOException {
            InputStream input = ImmersiveRailroading.proxy.getResourceStream(tex);
            this.image = TextureUtil.func_177053_a((InputStream)input);
            this.realWidth = this.image.getWidth();
            this.realHeight = this.image.getHeight();
            this.tex = tex;
        }

        public void extendSpace(Vec2f tex) {
            float u = tex.x;
            float v = -tex.y;
            this.minU = MathHelper.func_76141_d((float)Math.min((float)this.minU, u));
            this.maxU = MathHelper.func_76123_f((float)Math.max((float)this.maxU, u));
            this.minV = MathHelper.func_76141_d((float)Math.min((float)this.minV, v));
            this.maxV = MathHelper.func_76123_f((float)Math.max((float)this.maxV, v));
        }

        public void upload(int textureID, int originX, int originY, int sheetWidth, int sheetHeight) {
            this.originX = originX;
            this.originY = originY;
            this.sheetWidth = sheetWidth;
            this.sheetHeight = sheetHeight;
            int[] pixels = new int[this.realWidth * this.realHeight];
            this.image.getRGB(0, 0, this.realWidth, this.realHeight, pixels, 0, this.realWidth);
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)(this.realWidth * this.realHeight * 4));
            for (int y = 0; y < this.realHeight; ++y) {
                for (int x = 0; x < this.realWidth; ++x) {
                    int pixel = pixels[y * this.realWidth + x];
                    buffer.put((byte)(pixel >> 16 & 0xFF));
                    buffer.put((byte)(pixel >> 8 & 0xFF));
                    buffer.put((byte)(pixel >> 0 & 0xFF));
                    buffer.put((byte)(pixel >> 24 & 0xFF));
                }
            }
            buffer.flip();
            for (int cU = 0; cU < this.copiesU(); ++cU) {
                for (int cV = 0; cV < this.copiesV(); ++cV) {
                    int offX = originX + this.realWidth * cU;
                    int offY = originY + this.realHeight * cV;
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)offX, (int)offY, (int)this.realWidth, (int)this.realHeight, (int)6408, (int)5121, (ByteBuffer)buffer);
                }
            }
            this.image = null;
        }

        public int copiesU() {
            return this.maxU - this.minU;
        }

        public int copiesV() {
            return this.maxV - this.minV;
        }

        public int getAbsoluteWidth() {
            return this.realWidth * this.copiesU();
        }

        public int getAbsoluteHeight() {
            return this.realHeight * this.copiesV();
        }

        public float convertU(float relativeU) {
            return (float)this.originX / (float)this.sheetWidth + (relativeU - (float)this.minU) * ((float)this.realWidth / (float)this.sheetWidth);
        }

        public float convertV(float relativeV) {
            return (float)this.originY / (float)this.sheetHeight + (relativeV - (float)this.minV) * ((float)this.realHeight / (float)this.sheetHeight);
        }
    }
}

