/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.items.nbt.ItemComponent;
import cam72cam.immersiverailroading.items.nbt.ItemDefinition;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.render.OBJRender;
import cam72cam.immersiverailroading.render.StockRenderCache;
import cam72cam.immersiverailroading.util.GLBoolTracker;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import util.Matrix4;

public class StockItemComponentModel
implements IBakedModel {
    private OBJRender renderer;
    private List<String> groups;
    private Vec3d center;
    private double width;
    private double length;
    private double scale;

    public StockItemComponentModel() {
    }

    public StockItemComponentModel(ItemStack stack) {
        this.scale = ItemGauge.get(stack).scale();
        String defID = ItemDefinition.getID(stack);
        ItemComponentType item = ItemComponent.getComponentType(stack);
        EntityRollingStockDefinition def = DefinitionManager.getDefinition(defID);
        if (def == null) {
            ImmersiveRailroading.error("Item missing definition!", new Object[0]);
            stack.func_190920_e(0);
            return;
        }
        this.renderer = StockRenderCache.getRender(defID);
        this.groups = new ArrayList<String>();
        for (RenderComponentType r : item.render) {
            RenderComponent comp = def.getComponent(r, Gauge.STANDARD);
            if (comp == null) continue;
            this.groups.addAll(comp.modelIDs);
        }
        this.center = this.renderer.model.centerOfGroups(this.groups);
        this.width = this.renderer.model.widthOfGroups(this.groups);
        this.length = this.renderer.model.lengthOfGroups(this.groups);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (this.groups == null) {
            return new ArrayList<BakedQuad>();
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-this.center.field_72450_a), (double)(-this.center.field_72448_b), (double)(-this.center.field_72449_c));
        GLBoolTracker blend = new GLBoolTracker(3042, false);
        GLBoolTracker cull = new GLBoolTracker(2884, false);
        GLBoolTracker tex = new GLBoolTracker(3553, this.renderer.hasTexture());
        GLBoolTracker light = new GLBoolTracker(2896, false);
        this.renderer.bindTexture();
        this.renderer.drawGroups(this.groups);
        this.renderer.restoreTexture();
        blend.restore();
        cull.restore();
        tex.restore();
        light.restore();
        GL11.glPopMatrix();
        return new ArrayList<BakedQuad>();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideListHack();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        double scale = 1.0;
        if (this.width != 0.0 || this.length != 0.0) {
            scale = 0.95 / Math.max(this.width, this.length);
        }
        scale *= Math.sqrt(this.scale);
        Pair defaultVal = ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)cameraTransformType);
        switch (cameraTransformType) {
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().rotate(Math.toRadians(90.0), 0.0, 1.0, 0.0).rotate(Math.toRadians(-60.0), 0.0, 0.0, 1.0).translate(0.5, 0.25, 0.5).scale(0.2, 0.2, 0.2).toMatrix4f());
            }
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().rotate(Math.toRadians(90.0), 0.0, 1.0, 0.0).rotate(Math.toRadians(-30.0), 0.0, 0.0, 1.0).translate(0.5, 0.25, 0.5).scale(0.2, 0.2, 0.2).toMatrix4f());
            }
            case GROUND: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().translate(0.5, 0.5, 0.5).scale(0.2, 0.2, 0.2).toMatrix4f());
            }
            case FIXED: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case GUI: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().scale(scale, scale, scale).translate(0.5, 0.5, 0.0).toMatrix4f());
            }
            case HEAD: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().translate(0.0, 0.0, 0.5).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case NONE: {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public class ItemOverrideListHack
    extends ItemOverrideList {
        public ItemOverrideListHack() {
            super(new ArrayList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            return new StockItemComponentModel(stack);
        }
    }
}

