/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.items.nbt.ItemDefinition;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.render.OBJRender;
import cam72cam.immersiverailroading.render.StockRenderCache;
import cam72cam.immersiverailroading.util.GLBoolTracker;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import util.Matrix4;

public class StockItemModel
implements IBakedModel {
    private OBJRender model;
    private double scale;

    public StockItemModel() {
    }

    public StockItemModel(ItemStack stack) {
        this.scale = ItemGauge.get(stack).scale();
        String defID = ItemDefinition.getID(stack);
        this.model = StockRenderCache.getRender(defID);
        if (this.model == null) {
            stack.func_190920_e(0);
        }
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (this.model != null) {
            GLBoolTracker tex = new GLBoolTracker(3553, this.model.hasTexture());
            GLBoolTracker cull = new GLBoolTracker(2884, false);
            GL11.glPushMatrix();
            double scale = 0.2 * Math.sqrt(this.scale);
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            this.model.bindTexture();
            this.model.draw();
            this.model.restoreTexture();
            GL11.glPopMatrix();
            tex.restore();
            cull.restore();
        }
        return new ArrayList<BakedQuad>();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideListHack();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair defaultVal = ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)cameraTransformType);
        switch (cameraTransformType) {
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().rotate(Math.toRadians(60.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().rotate(Math.toRadians(10.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case GROUND: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case FIXED: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case GUI: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().translate(0.5, 0.0, 0.0).rotate(Math.toRadians(95.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case HEAD: {
                return Pair.of((Object)defaultVal.getLeft(), (Object)new Matrix4().translate(0.0, 0.0, 0.5).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).toMatrix4f());
            }
            case NONE: {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public class ItemOverrideListHack
    extends ItemOverrideList {
        public ItemOverrideListHack() {
            super(new ArrayList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            return new StockItemModel(stack);
        }
    }
}

