/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityBuildableRollingStock;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.model.MultiRenderComponent;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveSteamDefinition;
import cam72cam.immersiverailroading.render.OBJRender;
import cam72cam.immersiverailroading.util.GLBoolTracker;
import cam72cam.immersiverailroading.util.VecUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class StockModel
extends OBJRender {
    private static final int MALLET_ANGLE_REAR = -45;
    private boolean isBuilt;
    private List<RenderComponentType> availComponents;
    private double distanceTraveled;

    public StockModel(OBJModel objModel) {
        super(objModel);
    }

    private void initComponents(EntityBuildableRollingStock stock) {
        this.isBuilt = stock.isBuilt();
        if (!this.isBuilt) {
            this.availComponents = new ArrayList<RenderComponentType>();
            for (ItemComponentType item : stock.getItemComponents()) {
                this.availComponents.addAll(item.render);
            }
        }
    }

    private void drawComponent(RenderComponent component) {
        if (component != null) {
            if (!this.isBuilt) {
                if (!this.availComponents.contains((Object)component.type)) {
                    return;
                }
                this.availComponents.remove((Object)component.type);
            }
            this.drawGroups(component.modelIDs, component.scale);
        }
    }

    private void drawComponents(List<RenderComponent> components) {
        if (components == null) {
            return;
        }
        for (RenderComponent component : components) {
            this.drawComponent(component);
        }
    }

    public void draw(EntityRollingStock stock, float partialTicks) {
        GLBoolTracker tex = new GLBoolTracker(3553, super.hasTexture());
        if (stock instanceof EntityMoveableRollingStock) {
            EntityMoveableRollingStock mstock = (EntityMoveableRollingStock)stock;
            this.distanceTraveled = (double)mstock.distanceTraveled + mstock.getCurrentSpeed().minecraft() * ImmersiveRailroading.proxy.serverTicksPerClientTick() * (double)partialTicks * 1.1;
        } else {
            this.distanceTraveled = 0.0;
        }
        this.bindTexture();
        if (stock instanceof LocomotiveSteam) {
            this.drawSteamLocomotive((LocomotiveSteam)stock);
        } else if (stock instanceof LocomotiveDiesel) {
            this.drawDieselLocomotive((LocomotiveDiesel)stock);
        } else if (stock instanceof EntityMoveableRollingStock) {
            this.drawStandardStock((EntityMoveableRollingStock)stock);
        } else {
            this.draw();
        }
        this.restoreTexture();
        tex.restore();
    }

    private void drawStandardStock(EntityMoveableRollingStock stock) {
        Vec3d wheelPos;
        double relDist;
        double circumference;
        EntityRollingStockDefinition def = stock.getDefinition();
        this.initComponents(stock);
        this.drawComponent(def.getComponent(RenderComponentType.FRAME, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.SHELL, stock.gauge));
        List<RenderComponent> wheels = def.getComponents(RenderComponentType.FRAME_WHEEL_X, stock.gauge);
        if (wheels != null) {
            for (RenderComponent wheel : wheels) {
                circumference = wheel.height() * 3.1415927410125732;
                relDist = this.distanceTraveled % circumference;
                wheelPos = wheel.center();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)wheelPos.field_72450_a, (double)wheelPos.field_72448_b, (double)wheelPos.field_72449_c);
                GlStateManager.func_179114_b((float)((float)(360.0 * relDist / circumference)), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)(-wheelPos.field_72450_a), (double)(-wheelPos.field_72448_b), (double)(-wheelPos.field_72449_c));
                this.drawComponent(wheel);
                GlStateManager.func_179121_F();
            }
        }
        if (def.getComponent(RenderComponentType.BOGEY_POS, "FRONT", stock.gauge) != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-def.getBogeyFront(stock.gauge)), (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(180.0f - stock.getFrontYaw()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-(180.0f - stock.field_70177_z)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)def.getBogeyFront(stock.gauge), (float)0.0f, (float)0.0f);
            this.drawComponent(def.getComponent(RenderComponentType.BOGEY_POS, "FRONT", stock.gauge));
            wheels = def.getComponents(RenderComponentType.BOGEY_POS_WHEEL_X, "FRONT", stock.gauge);
            if (wheels != null) {
                for (RenderComponent wheel : wheels) {
                    circumference = wheel.height() * 3.1415927410125732;
                    relDist = this.distanceTraveled % circumference;
                    wheelPos = wheel.center();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)wheelPos.field_72450_a, (double)wheelPos.field_72448_b, (double)wheelPos.field_72449_c);
                    GlStateManager.func_179114_b((float)((float)(360.0 * relDist / circumference)), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179137_b((double)(-wheelPos.field_72450_a), (double)(-wheelPos.field_72448_b), (double)(-wheelPos.field_72449_c));
                    this.drawComponent(wheel);
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179121_F();
        }
        if (def.getComponent(RenderComponentType.BOGEY_POS, stock.gauge) != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-def.getBogeyRear(stock.gauge)), (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(180.0f - stock.getRearYaw()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-(180.0f - stock.field_70177_z)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)def.getBogeyRear(stock.gauge), (float)0.0f, (float)0.0f);
            this.drawComponent(def.getComponent(RenderComponentType.BOGEY_POS, "REAR", stock.gauge));
            wheels = def.getComponents(RenderComponentType.BOGEY_POS_WHEEL_X, "REAR", stock.gauge);
            if (wheels != null) {
                for (RenderComponent wheel : wheels) {
                    circumference = wheel.height() * 3.1415927410125732;
                    relDist = this.distanceTraveled % circumference;
                    wheelPos = wheel.center();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)wheelPos.field_72450_a, (double)wheelPos.field_72448_b, (double)wheelPos.field_72449_c);
                    GlStateManager.func_179114_b((float)((float)(360.0 * relDist / circumference)), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179137_b((double)(-wheelPos.field_72450_a), (double)(-wheelPos.field_72448_b), (double)(-wheelPos.field_72449_c));
                    this.drawComponent(wheel);
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179121_F();
        }
        if (this.isBuilt) {
            this.drawComponent(def.getComponent(RenderComponentType.REMAINING, stock.gauge));
        }
    }

    private void drawDieselLocomotive(EntityMoveableRollingStock stock) {
        EntityRollingStockDefinition def = stock.getDefinition();
        this.drawStandardStock(stock);
        this.drawComponent(def.getComponent(RenderComponentType.FUEL_TANK, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.ALTERNATOR, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.ENGINE_BLOCK, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.CAB, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.WHISTLE, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.BELL, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.HORN, stock.gauge));
    }

    private void drawSteamLocomotive(LocomotiveSteam stock) {
        LocomotiveSteamDefinition def = stock.getDefinition();
        this.initComponents(stock);
        this.drawBogies(stock);
        switch (def.getValveGear()) {
            case WALSCHAERTS: {
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_X, stock.gauge);
                this.drawDrivingWheels(stock, wheels);
                RenderComponent center = new MultiRenderComponent(wheels).scale(stock.gauge);
                RenderComponent wheel = wheels.get(wheels.size() / 2);
                this.drawWalschaerts(stock, "LEFT", 0, wheel.height(), center.center(), wheel.center());
                this.drawWalschaerts(stock, "RIGHT", -90, wheel.height(), center.center(), wheel.center());
                break;
            }
            case MALLET_WALSCHAERTS: {
                GL11.glPushMatrix();
                RenderComponent frontLocomotive = def.getComponent(RenderComponentType.FRONT_LOCOMOTIVE, stock.gauge);
                Vec3d frontVec = frontLocomotive.center();
                EntityMoveableRollingStock.PosRot frontPos = stock.predictFrontBogeyPosition((float)(-frontVec.field_72450_a - (double)def.getBogeyFront(stock.gauge)));
                Vec3d frontPosActual = VecUtil.rotateYaw(frontPos, 180.0f - stock.field_70177_z);
                GlStateManager.func_179137_b((double)frontPosActual.field_72450_a, (double)frontPosActual.field_72448_b, (double)frontPosActual.field_72449_c);
                GlStateManager.func_179114_b((float)(-(180.0f - stock.field_70177_z + frontPos.getRotation()) + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)(-frontVec.field_72450_a), (double)0.0, (double)0.0);
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_FRONT_X, stock.gauge);
                RenderComponent center = new MultiRenderComponent(wheels).scale(stock.gauge);
                this.drawComponent(def.getComponent(RenderComponentType.STEAM_CHEST_FRONT, stock.gauge));
                this.drawComponent(frontLocomotive);
                this.drawDrivingWheels(stock, wheels);
                RenderComponent wheel = wheels.get(wheels.size() / 2);
                this.drawWalschaerts(stock, "LEFT_FRONT", 0, wheel.height(), center.center(), wheel.center());
                this.drawWalschaerts(stock, "RIGHT_FRONT", -90, wheel.height(), center.center(), wheel.center());
                GL11.glPopMatrix();
                List<RenderComponent> wheels2 = def.getComponents(RenderComponentType.WHEEL_DRIVER_REAR_X, stock.gauge);
                RenderComponent center2 = new MultiRenderComponent(wheels2).scale(stock.gauge);
                this.drawDrivingWheels(stock, wheels2);
                RenderComponent wheel2 = wheels2.get(wheels2.size() / 2);
                this.drawWalschaerts(stock, "LEFT_REAR", -45, center2.height(), center2.center(), wheel2.center());
                this.drawWalschaerts(stock, "RIGHT_REAR", -135, center2.height(), center2.center(), wheel2.center());
                break;
            }
            case CLIMAX: {
                break;
            }
        }
        this.drawComponent(def.getComponent(RenderComponentType.FRAME, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.SHELL, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.BOILER_SEGMENT_X, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.FIREBOX, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.STEAM_CHEST, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.STEAM_CHEST_REAR, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.PIPING, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.CYLINDER_SIDE, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.CAB, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.WHISTLE, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.BELL, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.HORN, stock.gauge));
        if (stock.isBuilt()) {
            this.drawComponent(def.getComponent(RenderComponentType.REMAINING, stock.gauge));
        }
    }

    private void drawDrivingWheels(LocomotiveSteam stock, List<RenderComponent> wheels) {
        for (RenderComponent wheel : wheels) {
            double circumference = wheel.height() * 3.1415927410125732;
            double relDist = this.distanceTraveled % circumference;
            double wheelAngle = 360.0 * relDist / circumference;
            if (wheel.side.contains("REAR")) {
                wheelAngle += -45.0;
            }
            Vec3d wheelPos = wheel.center();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)wheelPos.field_72450_a, (double)wheelPos.field_72448_b, (double)wheelPos.field_72449_c);
            GlStateManager.func_179114_b((float)((float)wheelAngle), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-wheelPos.field_72450_a), (double)(-wheelPos.field_72448_b), (double)(-wheelPos.field_72449_c));
            this.drawComponent(wheel);
            GlStateManager.func_179121_F();
        }
    }

    private void drawBogies(EntityMoveableRollingStock stock) {
        Vec3d wheelPos;
        double relDist;
        double circumference;
        EntityRollingStockDefinition def = stock.getDefinition();
        RenderComponent frontBogey = def.getComponent(RenderComponentType.BOGEY_FRONT, stock.gauge);
        List<RenderComponent> frontBogeyWheels = def.getComponents(RenderComponentType.BOGEY_FRONT_WHEEL_X, stock.gauge);
        RenderComponent rearBogey = def.getComponent(RenderComponentType.BOGEY_REAR, stock.gauge);
        List<RenderComponent> rearBogeyWheels = def.getComponents(RenderComponentType.BOGEY_REAR_WHEEL_X, stock.gauge);
        if (frontBogey != null) {
            Vec3d frontVec = frontBogey.center();
            EntityMoveableRollingStock.PosRot frontPos = stock.predictFrontBogeyPosition((float)(-frontVec.field_72450_a - (double)def.getBogeyFront(stock.gauge)));
            GlStateManager.func_179094_E();
            Vec3d frontPosActual = VecUtil.rotateYaw(frontPos, 180.0f - stock.field_70177_z);
            GlStateManager.func_179137_b((double)frontPosActual.field_72450_a, (double)frontPosActual.field_72448_b, (double)frontPosActual.field_72449_c);
            GlStateManager.func_179114_b((float)(-(180.0f - stock.field_70177_z + frontPos.getRotation())), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-frontVec.field_72450_a), (double)0.0, (double)0.0);
            this.drawComponent(frontBogey);
            if (frontBogeyWheels != null) {
                for (RenderComponent wheel : frontBogeyWheels) {
                    circumference = wheel.height() * 3.1415927410125732;
                    relDist = this.distanceTraveled % circumference;
                    wheelPos = wheel.center();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)wheelPos.field_72450_a, (double)wheelPos.field_72448_b, (double)wheelPos.field_72449_c);
                    GlStateManager.func_179114_b((float)((float)(-360.0 * relDist / circumference)), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179137_b((double)(-wheelPos.field_72450_a), (double)(-wheelPos.field_72448_b), (double)(-wheelPos.field_72449_c));
                    this.drawComponent(wheel);
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179121_F();
        }
        if (rearBogey != null) {
            Vec3d rearVec = rearBogey.center();
            EntityMoveableRollingStock.PosRot rearPos = stock.predictRearBogeyPosition((float)(rearVec.field_72450_a + (double)def.getBogeyRear(stock.gauge)));
            GlStateManager.func_179094_E();
            Vec3d rearPosActual = VecUtil.rotateYaw(rearPos, 180.0f - stock.field_70177_z);
            GlStateManager.func_179137_b((double)rearPosActual.field_72450_a, (double)rearPosActual.field_72448_b, (double)rearPosActual.field_72449_c);
            GlStateManager.func_179114_b((float)(-(180.0f - stock.field_70177_z + rearPos.getRotation())), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-rearVec.field_72450_a), (double)0.0, (double)0.0);
            this.drawComponent(rearBogey);
            if (rearBogeyWheels != null) {
                for (RenderComponent wheel : rearBogeyWheels) {
                    circumference = wheel.height() * 3.1415927410125732;
                    relDist = this.distanceTraveled % circumference;
                    wheelPos = wheel.center();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)wheelPos.field_72450_a, (double)wheelPos.field_72448_b, (double)wheelPos.field_72449_c);
                    GlStateManager.func_179114_b((float)((float)(360.0 * relDist / circumference)), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179137_b((double)(-wheelPos.field_72450_a), (double)(-wheelPos.field_72448_b), (double)(-wheelPos.field_72449_c));
                    this.drawComponent(wheel);
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    private void drawWalschaerts(LocomotiveSteam stock, String side, int wheelAngleOffset, double diameter, Vec3d wheelCenter, Vec3d wheelPos) {
        LocomotiveSteamDefinition def = stock.getDefinition();
        double circumference = diameter * 3.1415927410125732;
        double relDist = this.distanceTraveled % circumference;
        double wheelAngle = 360.0 * relDist / circumference + (double)wheelAngleOffset;
        RenderComponent connectingRod = def.getComponent(RenderComponentType.SIDE_ROD_SIDE, side, stock.gauge);
        RenderComponent drivingRod = def.getComponent(RenderComponentType.MAIN_ROD_SIDE, side, stock.gauge);
        RenderComponent pistonRod = def.getComponent(RenderComponentType.PISTON_ROD_SIDE, side, stock.gauge);
        Vec3d connRodPos = connectingRod.center();
        double connRodOffset = connRodPos.field_72450_a - wheelCenter.field_72450_a;
        Vec3d drivingRodMin = drivingRod.min();
        Vec3d drivingRodMax = drivingRod.max();
        double drivingRodHeight = drivingRodMax.field_72448_b - drivingRodMin.field_72448_b;
        double drivingRodLength = drivingRodMax.field_72450_a - drivingRodMin.field_72450_a;
        double drivingRodCenterLength = drivingRodLength - drivingRodHeight;
        Vec3d connRodMovment = VecUtil.fromYaw(connRodOffset, (float)wheelAngle);
        double drivingRodHoriz = Math.sqrt(drivingRodCenterLength * drivingRodCenterLength - connRodMovment.field_72449_c * connRodMovment.field_72449_c);
        double pistonDelta = connRodMovment.field_72450_a - 0.3;
        RenderComponent crossHead = def.getComponent(RenderComponentType.UNION_LINK_SIDE, side, stock.gauge);
        RenderComponent combinationLever = def.getComponent(RenderComponentType.COMBINATION_LEVER_SIDE, side, stock.gauge);
        RenderComponent returnCrank = def.getComponent(RenderComponentType.ECCENTRIC_CRANK_SIDE, side, stock.gauge);
        RenderComponent returnCrankRod = def.getComponent(RenderComponentType.ECCENTRIC_ROD_SIDE, side, stock.gauge);
        RenderComponent slottedLink = def.getComponent(RenderComponentType.EXPANSION_LINK_SIDE, side, stock.gauge);
        double returnCrankHeight = returnCrank.height();
        double returnCrankLength = returnCrank.length();
        Vec3d returnCrankPos = returnCrank.center();
        float returnCrankAngle = 120.0f;
        double returnCrankRodHeight = returnCrankRod.height();
        double returnCrankRodLength = returnCrankRod.length();
        Vec3d returnCrankRodCenter = returnCrankRod.center();
        Vec3d crankOffset = VecUtil.fromYaw(returnCrankLength - returnCrankHeight, (float)(90.0 + wheelAngle + (double)returnCrankAngle));
        Vec3d slottedLinkMin = slottedLink.min();
        double slottedLinkWidth = slottedLink.length();
        Vec3d slottedLinkCenter = slottedLink.center();
        Vec3d returnCrankRodPos = new Vec3d(connRodMovment.field_72450_a, connRodMovment.field_72449_c, 0.0);
        returnCrankRodPos = returnCrankRodPos.func_72441_c(wheelPos.field_72450_a, wheelPos.field_72448_b, returnCrankRodCenter.field_72449_c);
        returnCrankRodPos = returnCrankRodPos.func_72441_c(crankOffset.field_72450_a, crankOffset.field_72449_c, 0.0);
        Vec3d returnCrankRodOffset = new Vec3d(returnCrankRodPos.field_72450_a - slottedLinkMin.field_72450_a, returnCrankRodPos.field_72448_b - slottedLinkMin.field_72448_b - slottedLinkWidth / 2.0, 0.0);
        float returnCrankRodAngle = (float)Math.toDegrees(MathHelper.func_181159_b((double)returnCrankRodOffset.field_72448_b, (double)returnCrankRodOffset.field_72450_a));
        Vec3d returnCrankRodActual = VecUtil.fromYaw(returnCrankRodLength - returnCrankHeight, returnCrankRodAngle);
        returnCrankRodActual = new Vec3d(returnCrankRodPos.field_72450_a - returnCrankRodActual.field_72449_c, returnCrankRodPos.field_72448_b + returnCrankRodActual.field_72450_a, 0.0);
        float slottedLinkAngle = (float)Math.toDegrees(MathHelper.func_181159_b((double)(-slottedLinkCenter.field_72450_a + returnCrankRodActual.field_72450_a), (double)(slottedLinkCenter.field_72448_b - returnCrankRodActual.field_72448_b)));
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-connRodOffset), (double)0.0, (double)0.0);
        GlStateManager.func_179137_b((double)connRodMovment.field_72450_a, (double)connRodMovment.field_72449_c, (double)0.0);
        this.drawComponent(connectingRod);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)connRodPos.field_72450_a, (double)connRodPos.field_72448_b, (double)connRodPos.field_72449_c);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(MathHelper.func_181159_b((double)connRodMovment.field_72449_c, (double)drivingRodHoriz))), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(-connRodPos.field_72450_a), (double)(-connRodPos.field_72448_b), (double)(-connRodPos.field_72449_c));
        this.drawComponent(drivingRod);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)connRodMovment.field_72450_a, (double)connRodMovment.field_72449_c, (double)0.0);
        GlStateManager.func_179137_b((double)wheelPos.field_72450_a, (double)wheelPos.field_72448_b, (double)returnCrankPos.field_72449_c);
        GlStateManager.func_179114_b((float)((float)(wheelAngle + (double)returnCrankAngle)), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(-returnCrankLength / 2.0 + returnCrankHeight / 2.0), (double)0.0, (double)0.0);
        GlStateManager.func_179137_b((double)(-returnCrankPos.field_72450_a), (double)(-returnCrankPos.field_72448_b), (double)(-returnCrankPos.field_72449_c));
        this.drawComponent(returnCrank);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)returnCrankRodPos.field_72450_a, (double)returnCrankRodPos.field_72448_b, (double)returnCrankRodPos.field_72449_c);
        GlStateManager.func_179114_b((float)returnCrankRodAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(-returnCrankRodLength / 2.0 + returnCrankRodHeight / 2.0), (double)0.0, (double)0.0);
        GlStateManager.func_179137_b((double)(-returnCrankRodCenter.field_72450_a), (double)(-returnCrankRodCenter.field_72448_b), (double)(-returnCrankRodCenter.field_72449_c));
        this.drawComponent(returnCrankRod);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)slottedLinkCenter.field_72450_a, (double)slottedLinkCenter.field_72448_b, (double)slottedLinkCenter.field_72449_c);
        GlStateManager.func_179114_b((float)slottedLinkAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(-slottedLinkCenter.field_72450_a), (double)(-slottedLinkCenter.field_72448_b), (double)(-slottedLinkCenter.field_72449_c));
        this.drawComponent(slottedLink);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)pistonDelta, (double)0.0, (double)0.0);
        this.drawComponent(pistonRod);
        this.drawComponent(crossHead);
        this.drawComponent(combinationLever);
        GlStateManager.func_179121_F();
    }
}

