/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.render.StockModel;
import java.util.HashMap;
import java.util.Map;

public class StockRenderCache {
    private static Map<String, StockModel> render_cache = new HashMap<String, StockModel>();

    public static void clearRenderCache() {
        render_cache = new HashMap<String, StockModel>();
        StockRenderCache.primeCache();
    }

    public static void primeCache() {
        for (String def : DefinitionManager.getDefinitionNames()) {
            ImmersiveRailroading.info("Priming Render Cache: %s", def);
            StockRenderCache.getRender(def);
        }
    }

    public static StockModel getRender(String defID) {
        EntityRollingStockDefinition def;
        if (!render_cache.containsKey(defID) && (def = DefinitionManager.getDefinition(defID)) != null) {
            render_cache.put(defID, new StockModel(def.getModel()));
        }
        return render_cache.get(defID);
    }
}

