/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.multiblock;

import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.multiblock.RailRollerMultiblock;
import cam72cam.immersiverailroading.render.OBJRender;
import cam72cam.immersiverailroading.render.multiblock.IMultiblockRender;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.util.GLBoolTracker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RailRollerRender
implements IMultiblockRender {
    private OBJRender renderer;
    private List<String> input;
    private List<String> output;
    private List<String> rest;

    public RailRollerRender() {
        try {
            this.renderer = new OBJRender(new OBJModel(new ResourceLocation("immersiverailroading", "models/multiblocks/rail_machine.obj"), 0.1f));
            this.input = new ArrayList<String>();
            this.output = new ArrayList<String>();
            this.rest = new ArrayList<String>();
            for (String name : this.renderer.model.groups.keySet()) {
                if (name.contains("INPUT_CAST")) {
                    this.input.add(name);
                    continue;
                }
                if (name.contains("OUTPUT_RAIL")) {
                    this.output.add(name);
                    continue;
                }
                this.rest.add(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(TileMultiblock te, double x, double y, double z, float partialTicks) {
        GLBoolTracker tex = new GLBoolTracker(3553, false);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
        GL11.glRotated((double)(te.getRotation() - 90.0), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-1.5, (double)0.0, (double)0.5);
        RailRollerMultiblock.RailRollerInstance tmb = (RailRollerMultiblock.RailRollerInstance)te.getMultiblock();
        int progress = tmb.getCraftProgress();
        if (progress != 0) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.0, (double)((double)(-(100 - progress)) / 10.0));
            GL11.glScaled((double)1.0, (double)1.0, (double)Math.max(0.25, Math.sqrt((double)progress / 100.0)));
            this.renderer.drawGroups(this.input);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        if (progress != 0) {
            GL11.glTranslated((double)0.0, (double)0.0, (double)((double)progress / 10.0));
            this.renderer.drawGroups(this.output);
        } else if (tmb.outputFull()) {
            this.renderer.drawGroups(this.output);
        }
        GL11.glPopMatrix();
        this.renderer.drawGroups(this.rest);
        GL11.glPopMatrix();
        tex.restore();
    }
}

