/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.rail;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.model.obj.OBJModel;
import cam72cam.immersiverailroading.render.OBJRender;
import cam72cam.immersiverailroading.render.rail.RailRenderUtil;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.immersiverailroading.util.VecUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class RailBuilderRender {
    private static OBJRender baseRailModel;
    private static Map<String, Integer> displayLists;

    public static void renderRailBuilder(RailInfo info) {
        Vec3d renderOff = new Vec3d(-0.5, 0.0, -0.5);
        switch (info.facing) {
            case EAST: {
                renderOff = renderOff.func_72441_c(0.0, 0.0, 1.0);
                break;
            }
            case NORTH: {
                renderOff = renderOff.func_72441_c(1.0, 0.0, 1.0);
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                renderOff = renderOff.func_72441_c(1.0, 0.0, 0.0);
                break;
            }
        }
        renderOff = VecUtil.rotateYaw(renderOff, (float)((info.direction == TrackDirection.LEFT ? -1 : 1) * info.quarter) / 4.0f * 90.0f - 90.0f);
        GL11.glTranslated((double)renderOff.field_72450_a, (double)renderOff.field_72448_b, (double)renderOff.field_72449_c);
        GL11.glTranslated((double)(-info.position.func_177958_n()), (double)(-info.position.func_177956_o()), (double)(-info.position.func_177952_p()));
        GL11.glTranslated((double)info.placementPosition.field_72450_a, (double)info.placementPosition.field_72448_b, (double)info.placementPosition.field_72449_c);
        renderOff = VecUtil.fromYaw((info.gauge.value() - Gauge.STANDARD.value()) * 0.34828 * 2.0, info.facing.func_176734_d().func_185119_l() - 90.0f);
        GL11.glTranslated((double)renderOff.field_72450_a, (double)renderOff.field_72448_b, (double)renderOff.field_72449_c);
        if (!displayLists.containsKey(RailRenderUtil.renderID(info))) {
            int displayList = GL11.glGenLists((int)1);
            GL11.glNewList((int)displayList, (int)4864);
            for (BuilderBase.VecYawPitch piece : info.getBuilder().getRenderData()) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)(180.0f - info.facing.func_176734_d().func_185119_l()), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)piece.field_72450_a, (double)piece.field_72448_b, (double)piece.field_72449_c);
                GL11.glRotatef((float)piece.getYaw(), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)piece.getPitch(), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                float length = piece.getLength();
                if (length == 1.0f) {
                    length = (float)info.gauge.scale();
                }
                GL11.glScaled((double)length, (double)info.gauge.scale(), (double)info.gauge.scale());
                if (piece.getGroups().size() != 0) {
                    ArrayList<String> groups = new ArrayList<String>();
                    for (String baseGroup : piece.getGroups()) {
                        for (String groupName : RailBuilderRender.baseRailModel.model.groups()) {
                            if (!groupName.contains(baseGroup)) continue;
                            groups.add(groupName);
                        }
                    }
                    baseRailModel.drawDirectGroups(groups);
                } else {
                    baseRailModel.drawDirect();
                }
                GL11.glPopMatrix();
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GL11.glEndList();
            displayLists.put(RailRenderUtil.renderID(info), displayList);
        }
        baseRailModel.bindTexture();
        GL11.glCallList((int)displayLists.get(RailRenderUtil.renderID(info)));
        baseRailModel.restoreTexture();
    }

    static {
        try {
            baseRailModel = new OBJRender(new OBJModel(new ResourceLocation("immersiverailroading", "models/block/track_1m.obj"), 0.05f));
        }
        catch (Exception e) {
            ImmersiveRailroading.catching(e);
        }
        displayLists = new HashMap<String, Integer>();
    }
}

