/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.tile;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.RailInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileRail
extends TileRailBase {
    private EnumFacing facing;
    private TrackItems type;
    private ItemStack railBed;
    private Gauge gauge;
    private Vec3d center;
    private SwitchState switchState = SwitchState.NONE;
    private int length;
    private int rotationQuarter;
    private TrackDirection direction = TrackDirection.NONE;
    private int turnQuarters;
    private Vec3d placementPosition;
    private List<ItemStack> drops;
    public boolean snowRenderFlagDirty = true;
    private RailInfo info;

    public static TileRail get(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileRail ? (TileRail)te : null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(-this.length), (double)(-this.length), (double)(-this.length), (double)this.length, (double)this.length, (double)this.length).func_186670_a(this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Math.pow(256.0, 2.0);
    }

    public EnumFacing getFacing() {
        if (this.facing == EnumFacing.DOWN) {
            return EnumFacing.NORTH;
        }
        return this.facing;
    }

    public void setFacing(EnumFacing value) {
        this.facing = value;
        this.func_70296_d();
    }

    public TrackItems getType() {
        return this.type;
    }

    public void setType(TrackItems value) {
        this.type = value;
        this.func_70296_d();
    }

    public ItemStack getRailBed() {
        return this.railBed;
    }

    public void setRailBed(ItemStack railBed) {
        this.railBed = railBed;
        this.func_70296_d();
    }

    public void setGauge(Gauge gauge) {
        this.gauge = gauge;
        this.func_70296_d();
    }

    public Gauge getGauge() {
        return this.gauge;
    }

    public SwitchState getSwitchState() {
        return this.switchState;
    }

    public void setSwitchState(SwitchState state) {
        if (state != this.switchState) {
            this.switchState = state;
            this.func_70296_d();
        }
    }

    public Vec3d getCenter() {
        if (this.center == null) {
            return null;
        }
        return this.center.func_72441_c((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
    }

    public double getRadius() {
        return this.length;
    }

    public void setCenter(Vec3d center) {
        this.center = center != null ? center.func_178786_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) : center;
        this.func_70296_d();
    }

    public TrackDirection getDirection() {
        return this.direction;
    }

    public void setDirection(TrackDirection dir) {
        this.direction = dir;
        this.func_70296_d();
    }

    public Vec3d getPlacementPosition() {
        return this.placementPosition.func_72441_c((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
    }

    public void setPlacementPosition(Vec3d placementPosition) {
        this.placementPosition = placementPosition.func_178786_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
        this.func_70296_d();
    }

    public int getLength() {
        return this.length;
    }

    public double getSlope() {
        return 1 / this.length;
    }

    public void setLength(int length) {
        this.length = length;
        this.func_70296_d();
    }

    public int getRotationQuarter() {
        return this.rotationQuarter;
    }

    public void setRotationQuarter(int val) {
        this.rotationQuarter = val;
        this.func_70296_d();
    }

    public int getTurnQuarters() {
        return this.turnQuarters;
    }

    public void setTurnQuarters(int quarters) {
        this.turnQuarters = quarters;
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int version = 0;
        if (nbt.func_74764_b("version")) {
            version = nbt.func_74762_e("version");
        }
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74771_c("facing"));
        this.type = TrackItems.valueOf(nbt.func_74779_i("type"));
        this.switchState = SwitchState.values()[nbt.func_74762_e("switchState")];
        this.length = nbt.func_74762_e("length");
        this.rotationQuarter = nbt.func_74762_e("rotationQuarter");
        this.direction = TrackDirection.values()[nbt.func_74762_e("direction")];
        this.turnQuarters = nbt.func_74762_e("turnQuarters");
        this.drops = new ArrayList<ItemStack>();
        if (nbt.func_74764_b("drops")) {
            NBTTagCompound dropNBT = nbt.func_74775_l("drops");
            int count = dropNBT.func_74762_e("count");
            for (int i = 0; i < count; ++i) {
                this.drops.add(new ItemStack(dropNBT.func_74775_l("drop_" + i)));
            }
        }
        switch (version) {
            case 0: {
                nbt.func_74782_a("railBed", (NBTBase)new ItemStack(Blocks.field_150351_n).serializeNBT());
            }
            case 1: {
                if (TileRail.getNBTVec3d(nbt, "center") != null) {
                    TileRail.setNBTVec3d(nbt, "center", TileRail.getNBTVec3d(nbt, "center").func_178786_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()));
                }
                TileRail.setNBTVec3d(nbt, "placementPosition", TileRail.getNBTVec3d(nbt, "placementPosition").func_178786_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()));
            }
            case 2: {
                nbt.func_74780_a("gauge", Gauge.STANDARD.value());
            }
        }
        this.railBed = new ItemStack(nbt.func_74775_l("railBed"));
        this.center = TileRail.getNBTVec3d(nbt, "center");
        this.placementPosition = TileRail.getNBTVec3d(nbt, "placementPosition");
        this.gauge = Gauge.from(nbt.func_74769_h("gauge"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.facing == null) {
            ImmersiveRailroading.error("INVALID TILE SAVE", new Object[0]);
            return super.func_189515_b(nbt);
        }
        nbt.func_74774_a("facing", (byte)this.facing.func_176745_a());
        nbt.func_74778_a("type", this.type.name());
        nbt.func_74768_a("switchState", this.switchState.ordinal());
        nbt.func_74768_a("length", this.length);
        nbt.func_74768_a("rotationQuarter", this.rotationQuarter);
        nbt.func_74768_a("direction", this.direction.ordinal());
        nbt.func_74768_a("turnQuarters", this.turnQuarters);
        if (this.drops != null && this.drops.size() != 0) {
            NBTTagCompound dropNBT = new NBTTagCompound();
            dropNBT.func_74768_a("count", this.drops.size());
            for (int i = 0; i < this.drops.size(); ++i) {
                dropNBT.func_74782_a("drop_" + i, (NBTBase)this.drops.get(i).serializeNBT());
            }
            nbt.func_74782_a("drops", (NBTBase)dropNBT);
        }
        nbt.func_74782_a("railBed", (NBTBase)this.railBed.serializeNBT());
        TileRail.setNBTVec3d(nbt, "center", this.center);
        TileRail.setNBTVec3d(nbt, "placementPosition", this.placementPosition);
        nbt.func_74780_a("gauge", this.gauge.value());
        return super.func_189515_b(nbt);
    }

    public RailInfo getRailRenderInfo() {
        if (!this.hasTileData && this.field_145850_b.field_72995_K) {
            return null;
        }
        if (this.info == null) {
            this.info = new RailInfo(this.func_174877_v(), this.func_145831_w(), this.getFacing().func_176734_d(), this.getType(), this.getDirection(), this.getLength(), this.getRotationQuarter(), this.getTurnQuarters(), this.getGauge(), this.getPlacementPosition(), this.getRailBed(), ItemStack.field_190927_a);
        }
        this.info.snowRenderFlagDirty = this.snowRenderFlagDirty;
        this.snowRenderFlagDirty = false;
        this.info.switchState = this.switchState;
        return this.info;
    }

    public void setDrops(List<ItemStack> drops) {
        this.drops = drops;
        this.func_70296_d();
    }

    public void spawnDrops() {
        if (!this.field_145850_b.field_72995_K && this.drops != null && this.drops.size() != 0) {
            for (ItemStack drop : this.drops) {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), drop));
            }
            this.drops = new ArrayList<ItemStack>();
        }
    }
}

