/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.tile;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.physics.MovementTrack;
import cam72cam.immersiverailroading.tile.SyncdTileEntity;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.ParticleUtil;
import cam72cam.immersiverailroading.util.RedstoneUtil;
import cam72cam.immersiverailroading.util.SwitchUtil;
import cam72cam.immersiverailroading.util.VecUtil;
import java.util.List;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import trackapi.lib.ITrackTile;

public class TileRailBase
extends SyncdTileEntity
implements ITrackTile,
ITickable {
    private BlockPos parent;
    private float height = 0.0f;
    private Augment augment;
    private String augmentFilterID;
    private int snowLayers = 0;
    protected boolean flexible = false;
    private boolean willBeReplaced = false;
    private NBTTagCompound replaced;
    private boolean skipNextRefresh = false;
    public ItemStack railBedCache = null;
    private FluidTank augmentTank = null;
    private int redstoneLevel = 0;
    private int clientLastTankAmount = 0;
    private long clientSoundTimeout = 0L;
    private int ticksExisted;

    public static TileRailBase get(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileRailBase ? (TileRailBase)te : null;
    }

    @Override
    public boolean isLoaded() {
        return !this.field_145850_b.field_72995_K || this.hasTileData;
    }

    public void setHeight(float height) {
        this.height = height;
        this.func_70296_d();
    }

    public float getHeight() {
        return this.height;
    }

    public void setAugment(Augment augment) {
        this.augment = augment;
        this.func_70296_d();
    }

    public boolean setAugmentFilter(String definitionID) {
        this.augmentFilterID = definitionID != this.augmentFilterID ? definitionID : null;
        this.func_70296_d();
        return this.augmentFilterID != null;
    }

    public Augment getAugment() {
        return this.augment;
    }

    public int getSnowLayers() {
        return this.snowLayers;
    }

    public void setSnowLayers(int snowLayers) {
        this.snowLayers = snowLayers;
        this.func_70296_d();
    }

    public float getFullHeight() {
        return this.height + (float)this.snowLayers / 8.0f;
    }

    public boolean handleSnowTick() {
        if (this.snowLayers < (Config.deepSnow ? 8 : 1)) {
            ++this.snowLayers;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public BlockPos getParent() {
        if (this.parent == null) {
            ImmersiveRailroading.warn("Invalid block without parent", new Object[0]);
            this.field_145850_b.func_175698_g(this.field_174879_c);
            return null;
        }
        return this.parent.func_177971_a((Vec3i)this.field_174879_c);
    }

    public void setParent(BlockPos pos) {
        this.parent = pos.func_177973_b((Vec3i)this.field_174879_c);
        this.func_70296_d();
    }

    public boolean isFlexible() {
        return this.flexible;
    }

    public ItemStack getRenderRailBed() {
        TileRail pt;
        if (this.railBedCache == null && (pt = this.getParentTile()) != null) {
            this.railBedCache = pt.getRailBed();
        }
        return this.railBedCache;
    }

    @Override
    public void writeUpdateNBT(NBTTagCompound nbt) {
        if (this.getRenderRailBed() != null) {
            nbt.func_74782_a("renderBed", (NBTBase)this.getRenderRailBed().serializeNBT());
        }
    }

    @Override
    public void readUpdateNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("renderBed")) {
            this.railBedCache = new ItemStack(nbt.func_74775_l("renderBed"));
        }
        if (this.augmentTank != null && this.augment == Augment.WATER_TROUGH) {
            int delta = this.clientLastTankAmount - this.augmentTank.getFluidAmount();
            if (delta > 0) {
                for (int i = 0; i < delta / 10; ++i) {
                    for (EnumFacing facing : EnumFacing.field_176754_o) {
                        ParticleUtil.spawnParticle(this.field_145850_b, EnumParticleTypes.WATER_SPLASH, new Vec3d((Vec3i)this.field_174879_c.func_177972_a(facing)).func_72441_c(0.5, 0.5, 0.5));
                    }
                }
                if (this.clientSoundTimeout < this.field_145850_b.func_72820_D()) {
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    this.clientSoundTimeout = this.field_145850_b.func_72820_D() + 10L;
                }
            }
            this.clientLastTankAmount = this.augmentTank.getFluidAmount();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int version = 0;
        if (nbt.func_74764_b("version")) {
            version = nbt.func_74762_e("version");
        }
        this.height = nbt.func_74760_g("height");
        int oldSnowLayers = this.snowLayers;
        this.snowLayers = nbt.func_74762_e("snowLayers");
        if (oldSnowLayers > this.snowLayers && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 30 * oldSnowLayers; ++i) {
                ParticleUtil.spawnParticle(this.field_145850_b, EnumParticleTypes.SNOWBALL, this.getCenterOfRail().func_72441_c(Math.random() * 4.0 - 2.0, 1.0, Math.random() * 4.0 - 2.0));
            }
        }
        this.flexible = nbt.func_74767_n("flexible");
        if (nbt.func_74764_b("replaced")) {
            this.replaced = nbt.func_74775_l("replaced");
        }
        if (nbt.func_74764_b("augment")) {
            this.augment = Augment.values()[nbt.func_74762_e("augment")];
        }
        switch (version) {
            case 0: 
            case 1: {
                TileRailBase.setNBTBlockPos(nbt, "parent", TileRailBase.getNBTBlockPos(nbt, "parent").func_177973_b((Vec3i)this.field_174879_c));
            }
        }
        this.parent = TileRailBase.getNBTBlockPos(nbt, "parent");
        if (this.field_145850_b != null && this.getParentTile() != null) {
            this.getParentTile().snowRenderFlagDirty = true;
        }
        if (nbt.func_74764_b("augmentTank")) {
            this.createAugmentTank();
            this.augmentTank.readFromNBT(nbt.func_74775_l("augmentTank"));
        }
        if (nbt.func_74764_b("augmentFilterID")) {
            this.augmentFilterID = nbt.func_74779_i("augmentFilterID");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        TileRailBase.setNBTBlockPos(nbt, "parent", this.parent);
        nbt.func_74776_a("height", this.height);
        nbt.func_74768_a("snowLayers", this.snowLayers);
        nbt.func_74757_a("flexible", this.flexible);
        if (this.replaced != null) {
            nbt.func_74782_a("replaced", (NBTBase)this.replaced);
        }
        if (this.augment != null) {
            nbt.func_74768_a("augment", this.augment.ordinal());
            if (this.augmentTank != null) {
                nbt.func_74782_a("augmentTank", (NBTBase)this.augmentTank.writeToNBT(new NBTTagCompound()));
            }
            if (this.augmentFilterID != null) {
                nbt.func_74778_a("augmentFilterID", this.augmentFilterID);
            }
        }
        nbt.func_74768_a("version", 3);
        return super.func_189515_b(nbt);
    }

    protected static final void setNBTBlockPos(NBTTagCompound nbt, String key, BlockPos value) {
        if (value != null) {
            nbt.func_74772_a(key, value.func_177986_g());
        }
    }

    protected static final void setNBTVec3d(NBTTagCompound nbt, String key, Vec3d value) {
        if (value != null) {
            nbt.func_74780_a(key + "X", value.field_72450_a);
            nbt.func_74780_a(key + "Y", value.field_72448_b);
            nbt.func_74780_a(key + "Z", value.field_72449_c);
        }
    }

    protected static final BlockPos getNBTBlockPos(NBTTagCompound nbt, String key) {
        return nbt.func_74764_b(key) ? BlockPos.func_177969_a((long)nbt.func_74763_f(key)) : null;
    }

    protected static final Vec3d getNBTVec3d(NBTTagCompound nbt, String key) {
        if (!(nbt.func_74764_b(key + "X") && nbt.func_74764_b(key + "Y") && nbt.func_74764_b(key + "Z"))) {
            return null;
        }
        return new Vec3d(nbt.func_74769_h(key + "X"), nbt.func_74769_h(key + "Y"), nbt.func_74769_h(key + "Z"));
    }

    public Vec3d getCenterOfRail() {
        return new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.0, 0.5);
    }

    public TileRail getParentTile() {
        if (this.getParent() == null) {
            return null;
        }
        TileRail te = TileRail.get((IBlockAccess)this.field_145850_b, this.getParent());
        if (te == null || !te.isLoaded()) {
            return null;
        }
        return te;
    }

    public void setReplaced(NBTTagCompound replaced) {
        this.replaced = replaced;
        this.func_70296_d();
    }

    public NBTTagCompound getReplaced() {
        return this.replaced;
    }

    public void setSkipNextRefresh() {
        this.skipNextRefresh = true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (this.skipNextRefresh) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    public void setWillBeReplaced(boolean value) {
        this.willBeReplaced = value;
    }

    public boolean getWillBeReplaced() {
        return this.willBeReplaced;
    }

    public void cleanSnow() {
        int snow = this.getSnowLayers();
        if (snow > 1) {
            this.setSnowLayers(1);
            int snowDown = snow - 1;
            for (int i = 1; i <= 3; ++i) {
                Object[] horiz = EnumFacing.field_176754_o;
                if (Math.random() > 0.5) {
                    ArrayUtils.reverse((Object[])horiz);
                }
                for (Object facing : horiz) {
                    BlockPos ph = this.field_145850_b.func_175725_q(this.field_174879_c.func_177967_a((EnumFacing)facing, i));
                    for (int j = 0; j < 3; ++j) {
                        IBlockState state = this.field_145850_b.func_180495_p(ph);
                        if (this.field_145850_b.func_175623_d(ph) && !BlockUtil.isRail(this.field_145850_b, ph.func_177977_b())) {
                            this.field_145850_b.func_175656_a(ph, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(snowDown)));
                            return;
                        }
                        if (this.field_145850_b.func_180495_p(ph).func_177230_c() == Blocks.field_150433_aE) {
                            ph = ph.func_177984_a();
                            continue;
                        }
                        if (this.field_145850_b.func_180495_p(ph).func_177230_c() == Blocks.field_150431_aC) {
                            Integer currSnow = (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a);
                            if (currSnow == 8) {
                                ph = ph.func_177984_a();
                                continue;
                            }
                            int toAdd = Math.min(8 - currSnow, snowDown);
                            this.field_145850_b.func_175656_a(ph, state.func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(currSnow + toAdd)));
                            if ((snowDown -= toAdd) <= 0) {
                                return;
                            }
                        }
                        ph = ph.func_177977_b();
                    }
                }
            }
        }
    }

    public double getTrackGauge() {
        TileRail parent = this.getParentTile();
        if (parent != null) {
            return parent.getGauge().value();
        }
        return 0.0;
    }

    public Vec3d getNextPosition(Vec3d currentPosition, Vec3d motion) {
        TileRail tile;
        TileRail tileRail = tile = this instanceof TileRail ? (TileRail)this : this.getParentTile();
        if (tile == null) {
            return currentPosition;
        }
        if (SwitchUtil.getSwitchState(tile, currentPosition) == SwitchState.STRAIGHT) {
            tile = tile.getParentTile();
        }
        if (tile == null) {
            return currentPosition;
        }
        double distanceMeters = motion.func_72433_c();
        float rotationYaw = VecUtil.toYaw(motion);
        return MovementTrack.nextPosition(this.field_145850_b, currentPosition, tile, rotationYaw, distanceMeters);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.getAugment() != null) {
            switch (this.getAugment()) {
                case FLUID_LOADER: 
                case FLUID_UNLOADER: 
                case WATER_TROUGH: {
                    return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
                }
                case ITEM_LOADER: 
                case ITEM_UNLOADER: {
                    return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
                }
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T extends EntityRollingStock> T getStockNearBy(Class<T> type, Capability<?> capability) {
        AxisAlignedBB bb = new AxisAlignedBB(this.field_174879_c.func_177968_d().func_177976_e(), this.field_174879_c.func_177981_b(3).func_177974_f().func_177978_c());
        List stocks = this.field_145850_b.func_72872_a(type, bb);
        for (EntityRollingStock stock : stocks) {
            if (capability != null && !stock.hasCapability(capability, null) || this.augmentFilterID != null && !this.augmentFilterID.equals(stock.getDefinitionID())) continue;
            return (T)((Object)stock);
        }
        return null;
    }

    public EntityRollingStock getStockNearBy(Capability<?> capability) {
        return this.getStockNearBy(EntityRollingStock.class, capability);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.getAugment() != null) {
            switch (this.getAugment()) {
                case FLUID_LOADER: 
                case FLUID_UNLOADER: 
                case WATER_TROUGH: {
                    if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                        if (this.augmentTank == null) {
                            this.createAugmentTank();
                        }
                        return (T)this.augmentTank;
                    }
                }
                case ITEM_LOADER: 
                case ITEM_UNLOADER: {
                    if (capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) break;
                    EntityRollingStock stock = this.getStockNearBy(capability);
                    if (stock != null) {
                        return (T)stock.getCapability(capability, null);
                    }
                    return (T)new ItemStackHandler(0);
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    private void balanceTanks() {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            TileRailBase neighbor = TileRailBase.get((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(facing));
            if (neighbor == null || neighbor.augmentTank == null || neighbor.augmentTank.getFluidAmount() + 1 >= this.augmentTank.getFluidAmount()) continue;
            this.transferAll((IFluidHandler)this.augmentTank, (IFluidHandler)neighbor.augmentTank, (this.augmentTank.getFluidAmount() - neighbor.augmentTank.getFluidAmount()) / 2);
            this.func_70296_d();
        }
    }

    private void createAugmentTank() {
        switch (this.augment) {
            case FLUID_LOADER: 
            case FLUID_UNLOADER: {
                this.augmentTank = new FluidTank(1000);
                break;
            }
            case WATER_TROUGH: {
                this.augmentTank = new FluidTank(FluidRegistry.WATER, 0, 1000){

                    protected void onContentsChanged() {
                        TileRailBase.this.balanceTanks();
                        TileRailBase.this.func_70296_d();
                    }
                };
                break;
            }
        }
    }

    public void transferAll(IFluidHandler source, IFluidHandler dest, int maxQuantity) {
        FluidStack possibleDrain = source.drain(maxQuantity, false);
        if (possibleDrain == null || possibleDrain.amount == 0) {
            return;
        }
        int filled = dest.fill(possibleDrain, true);
        source.drain(filled, true);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.augment == null) {
            return;
        }
        ++this.ticksExisted;
        Capability capability = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        switch (this.augment) {
            case FLUID_LOADER: {
                EntityRollingStock stock;
                if (this.augmentTank == null) {
                    this.createAugmentTank();
                }
                if ((stock = this.getStockNearBy(capability)) == null) break;
                this.transferAll((IFluidHandler)this.augmentTank, (IFluidHandler)stock.getCapability(capability, null), 10);
                break;
            }
            case FLUID_UNLOADER: {
                EntityRollingStock stock;
                if (this.augmentTank == null) {
                    this.createAugmentTank();
                }
                if ((stock = this.getStockNearBy(capability)) == null) break;
                this.transferAll((IFluidHandler)stock.getCapability(capability, null), (IFluidHandler)this.augmentTank, 10);
                break;
            }
            case WATER_TROUGH: {
                Tender tender;
                if (this.augmentTank == null) {
                    this.createAugmentTank();
                }
                if ((tender = this.getStockNearBy(Tender.class, capability)) != null) {
                    this.transferAll((IFluidHandler)this.augmentTank, (IFluidHandler)tender.getCapability(capability, null), TileRailBase.waterPressureFromSpeed(tender.getCurrentSpeed().metric()));
                    break;
                }
                if (this.ticksExisted % 20 != 0) break;
                this.balanceTanks();
                break;
            }
            case LOCO_CONTROL: {
                Locomotive loco = this.getStockNearBy(Locomotive.class, null);
                if (loco == null) break;
                int power = RedstoneUtil.getPower(this.field_145850_b, this.field_174879_c);
                loco.setThrottle((float)power / 15.0f);
                if (power == 0) {
                    loco.setAirBrake(1.0f);
                    break;
                }
                loco.setAirBrake(0.0f);
                break;
            }
            case DETECTOR: {
                boolean currentRedstone;
                boolean provideRedstone = this.getStockNearBy(null) != null;
                boolean bl = currentRedstone = this.redstoneLevel != 0;
                if (provideRedstone == currentRedstone) break;
                this.redstoneLevel = provideRedstone ? 15 : 0;
                this.func_70296_d();
                break;
            }
        }
    }

    public int getRedstoneLevel() {
        return this.redstoneLevel;
    }

    public double getTankLevel() {
        return this.augmentTank == null ? 0.0 : (double)this.augmentTank.getFluidAmount() / (double)this.augmentTank.getCapacity();
    }

    private static int waterPressureFromSpeed(double speed) {
        if (speed < 0.0) {
            return 0;
        }
        return (int)(speed * speed / 200.0);
    }
}

