/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.RailInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class BuilderBase {
    protected ArrayList<TrackBase> tracks = new ArrayList();
    public World world;
    int x;
    int y;
    int z;
    public EnumFacing rotation;
    private int[] translation;
    public RailInfo info;
    private BlockPos parent_pos;
    public boolean overrideFlexible = false;
    public List<ItemStack> drops;
    public Gauge gauge;

    public BuilderBase(RailInfo info, BlockPos pos) {
        this.info = info;
        this.rotation = info.facing;
        this.world = info.world;
        this.gauge = info.gauge;
        this.parent_pos = pos;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public abstract List<VecYawPitch> getRenderData();

    public void setRelativeTranslate(int x, int y, int z) {
        this.translation = new int[]{x, y, z};
    }

    public PosRot convertRelativeCenterPositions(int rel_x, int rel_y, int rel_z, EnumFacing rel_rotation) {
        if (rel_x >= 1) {
            switch (this.rotation) {
                case SOUTH: {
                    rel_x += 0;
                    rel_z += 0;
                    break;
                }
                case WEST: {
                    rel_x += 0;
                    --rel_z;
                    break;
                }
                case NORTH: {
                    --rel_x;
                    --rel_z;
                    break;
                }
                case EAST: {
                    --rel_x;
                    rel_z += 0;
                }
            }
        } else {
            switch (this.rotation) {
                case EAST: {
                    rel_x += 0;
                    rel_z += 0;
                    break;
                }
                case NORTH: {
                    rel_x += 0;
                    --rel_z;
                    break;
                }
                case WEST: {
                    ++rel_x;
                    --rel_z;
                    break;
                }
                case SOUTH: {
                    ++rel_x;
                    rel_z += 0;
                }
            }
        }
        return this.convertRelativePositions(rel_x, rel_y, rel_z, rel_rotation);
    }

    public PosRot convertRelativePositions(int rel_x, int rel_y, int rel_z, EnumFacing rel_rotation) {
        if (this.translation != null) {
            rel_x += this.translation[0];
            rel_y += this.translation[1];
            rel_z += this.translation[2];
        }
        EnumFacing newrot = EnumFacing.func_176733_a((double)(rel_rotation.func_185119_l() + this.rotation.func_185119_l()));
        switch (this.rotation) {
            case SOUTH: {
                return new PosRot(new BlockPos(this.x + rel_x, this.y + rel_y, this.z + rel_z), newrot);
            }
            case WEST: {
                return new PosRot(new BlockPos(this.x - rel_z, this.y + rel_y, this.z + rel_x), newrot);
            }
            case NORTH: {
                return new PosRot(new BlockPos(this.x - rel_x, this.y + rel_y, this.z - rel_z), newrot);
            }
            case EAST: {
                return new PosRot(new BlockPos(this.x + rel_z, this.y + rel_y, this.z - rel_x), newrot);
            }
        }
        return null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean canBuild() {
        for (TrackBase track : this.tracks) {
            if (track.canPlaceTrack()) continue;
            return false;
        }
        return true;
    }

    public void build() {
        if (!this.canBuild()) {
            return;
        }
        for (TrackBase track : this.tracks) {
            track.placeTrack();
        }
    }

    public List<TrackBase> getTracksForRender() {
        return this.tracks;
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public void setParentPos(BlockPos pos) {
        this.parent_pos = this.convertRelativePositions(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.rotation);
    }

    public BlockPos getParentPos() {
        return this.parent_pos;
    }

    public int costTies() {
        return MathHelper.func_76143_f((double)((double)(this.tracks.size() / 3) * Config.TieCostMultiplier));
    }

    public int costRails() {
        return MathHelper.func_76143_f((double)((double)(this.tracks.size() * 2 / 3) * Config.RailCostMultiplier));
    }

    public int costBed() {
        return MathHelper.func_76143_f((double)((double)this.tracks.size() * 0.1 * Config.BedCostMultiplier));
    }

    public int costFill() {
        int fillCount = 0;
        for (TrackBase track : this.tracks) {
            if (!BlockUtil.canBeReplaced(this.world, track.getPos().func_177977_b(), false)) continue;
            ++fillCount;
        }
        return MathHelper.func_76123_f((float)(this.info.railBedFill.func_77973_b() != Items.field_190931_a ? (float)fillCount : 0.0f));
    }

    public void setDrops(List<ItemStack> drops) {
        this.drops = drops;
    }

    public class PosRot
    extends BlockPos {
        private EnumFacing rot;

        public EnumFacing getRotation() {
            return this.rot;
        }

        public PosRot(BlockPos pos, EnumFacing rot) {
            super((Vec3i)pos);
            this.rot = rot;
        }
    }

    public class VecYawPitch
    extends Vec3d {
        private float yaw;
        private float pitch;
        private float length;
        private List<String> groups;

        public VecYawPitch(double xIn, double yIn, double zIn, float yaw, String ... groups) {
            super(xIn, yIn, zIn);
            this.yaw = yaw;
            this.pitch = 0.0f;
            this.length = 1.0f;
            this.groups = Arrays.asList(groups);
        }

        public VecYawPitch(double xIn, double yIn, double zIn, float yaw, float pitch, String ... groups) {
            this(xIn, yIn, zIn, yaw, groups);
            this.pitch = pitch;
        }

        public VecYawPitch(double xIn, double yIn, double zIn, float yaw, float pitch, float length, String ... groups) {
            this(xIn, yIn, zIn, yaw, pitch, groups);
            this.length = length;
        }

        public float getYaw() {
            return this.yaw;
        }

        public float getPitch() {
            return this.pitch;
        }

        public float getLength() {
            return this.length;
        }

        public List<String> getGroups() {
            return this.groups;
        }
    }
}

