/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.TrackGag;
import cam72cam.immersiverailroading.track.TrackRail;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.immersiverailroading.util.VecUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class BuilderCrossing
extends BuilderBase {
    public BuilderCrossing(RailInfo info, BlockPos pos) {
        super(info, pos);
        info.length = 3;
        this.setParentPos(new BlockPos(0, 0, 0));
        this.tracks.add(new TrackRail(this, 0, 0, 0, EnumFacing.NORTH, TrackItems.CROSSING, 3, info.quarter, info.placementPosition));
        int blocks = 1;
        for (int i = -blocks; i <= blocks; ++i) {
            for (int j = -blocks; j <= blocks; ++j) {
                if (i == 0 && j == 0) continue;
                this.tracks.add(new TrackGag(this, i, 0, j));
            }
        }
    }

    @Override
    public List<BuilderBase.VecYawPitch> getRenderData() {
        double i;
        ArrayList<BuilderBase.VecYawPitch> data = new ArrayList<BuilderBase.VecYawPitch>();
        float angle = 0.0f;
        this.info.length = 3;
        Vec3d pos = VecUtil.rotateYaw(new Vec3d(-0.5, 0.0, 0.0), angle - 90.0f);
        data.add((BuilderBase)this.new BuilderBase.VecYawPitch(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c - 1.0, -angle, 0.0f, this.info.length, "RAIL_RIGHT", "RAIL_LEFT"));
        for (i = 0.0; i < (double)this.info.length - this.gauge.scale() / 2.0; i += this.gauge.scale()) {
            pos = VecUtil.rotateYaw(new Vec3d(-0.5, 0.0, i), angle - 90.0f);
            data.add((BuilderBase)this.new BuilderBase.VecYawPitch(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c - 1.0, -angle, "RAIL_BASE"));
        }
        pos = VecUtil.rotateYaw(new Vec3d(-0.5, 0.0, 0.0), (angle -= 90.0f) - 90.0f);
        data.add((BuilderBase)this.new BuilderBase.VecYawPitch(pos.field_72450_a - (2.0 - this.gauge.scale()), pos.field_72448_b, pos.field_72449_c + this.gauge.scale(), -angle, 0.0f, this.info.length, "RAIL_RIGHT", "RAIL_LEFT"));
        for (i = 0.0; i < (double)this.info.length - this.gauge.scale() / 2.0; i += this.gauge.scale()) {
            pos = VecUtil.rotateYaw(new Vec3d(-0.5, 0.0, i), angle - 90.0f);
            data.add((BuilderBase)this.new BuilderBase.VecYawPitch(pos.field_72450_a - (2.0 - this.gauge.scale()), pos.field_72448_b, pos.field_72449_c + this.gauge.scale(), -angle, "RAIL_BASE"));
        }
        return data;
    }
}

