/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.track.TrackGag;
import cam72cam.immersiverailroading.track.TrackRail;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.immersiverailroading.util.VecUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public class BuilderStraight
extends BuilderBase {
    protected float angle;
    public int mainX;
    public int mainZ;

    public BuilderStraight(RailInfo info, BlockPos pos) {
        this(info, pos, false);
    }

    public BuilderStraight(RailInfo info, BlockPos pos, boolean endOfTrack) {
        super(info, pos);
        if (info.direction == TrackDirection.LEFT) {
            info.quarter = -info.quarter;
        }
        HashSet<Pair> positions = new HashSet<Pair>();
        HashSet<Pair> flexPositions = new HashSet<Pair>();
        this.angle = (float)info.quarter / 4.0f * 90.0f;
        double actualLength = info.length;
        float dist = 0.0f;
        while ((double)dist < actualLength) {
            Vec3d gagPos = VecUtil.fromYaw(dist, this.angle);
            for (double q = -this.gauge.value(); q <= this.gauge.value(); q += 0.1) {
                Vec3d nextUp = VecUtil.fromYaw(q, 90.0f);
                int posX = (int)(gagPos.field_72450_a + nextUp.field_72450_a);
                int posZ = (int)(gagPos.field_72449_c + nextUp.field_72449_c);
                positions.add(Pair.of((Object)posX, (Object)posZ));
                if (!(dist < 3.0f) && !((double)dist > actualLength - 3.0)) continue;
                flexPositions.add(Pair.of((Object)posX, (Object)posZ));
            }
            if (endOfTrack) {
                if (Math.ceil(dist) == Math.ceil(actualLength)) {
                    this.mainX = (int)gagPos.field_72450_a;
                    this.mainZ = (int)gagPos.field_72449_c;
                }
            } else if (Math.ceil(dist) == Math.ceil(actualLength / 2.0)) {
                this.mainX = (int)gagPos.field_72450_a;
                this.mainZ = (int)gagPos.field_72449_c;
            }
            dist = (float)((double)dist + 0.25);
        }
        this.setParentPos(new BlockPos(this.mainX, 0, this.mainZ));
        TrackRail main = new TrackRail(this, this.mainX, 0, this.mainZ, EnumFacing.NORTH, info.type, info.length, info.quarter, info.placementPosition);
        this.tracks.add(main);
        for (Pair pair : positions) {
            if ((Integer)pair.getLeft() == this.mainX && (Integer)pair.getRight() == this.mainZ) continue;
            TrackGag tg = new TrackGag(this, (Integer)pair.getLeft(), 0, (Integer)pair.getRight());
            if (flexPositions.contains(pair)) {
                tg.setFlexible();
            }
            this.tracks.add(tg);
        }
    }

    @Override
    public List<TrackBase> getTracksForRender() {
        return this.tracks;
    }

    @Override
    public List<BuilderBase.VecYawPitch> getRenderData() {
        ArrayList<BuilderBase.VecYawPitch> data = new ArrayList<BuilderBase.VecYawPitch>();
        Vec3d pos = VecUtil.rotateYaw(new Vec3d(-0.5, 0.0, 0.0), this.angle - 90.0f);
        data.add((BuilderBase)this.new BuilderBase.VecYawPitch(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, -this.angle, 0.0f, this.info.length, "RAIL_RIGHT", "RAIL_LEFT"));
        for (double i = 0.0; i < (double)this.info.length - this.gauge.scale() / 2.0; i += this.gauge.scale()) {
            pos = VecUtil.rotateYaw(new Vec3d(-0.5, 0.0, i), this.angle - 90.0f);
            data.add((BuilderBase)this.new BuilderBase.VecYawPitch(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, -this.angle, "RAIL_BASE"));
        }
        return data;
    }
}

