/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.BuilderStraight;
import cam72cam.immersiverailroading.track.BuilderTurn;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.track.TrackGag;
import cam72cam.immersiverailroading.track.TrackRail;
import cam72cam.immersiverailroading.util.RailInfo;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class BuilderSwitch
extends BuilderBase {
    private BuilderTurn turnBuilder;
    private BuilderStraight straightBuilder;

    public BuilderSwitch(RailInfo info, BlockPos pos) {
        super(info, pos);
        info.quarter = 0;
        RailInfo turnInfo = info.clone();
        turnInfo.type = TrackItems.TURN;
        this.straightBuilder = new BuilderStraight(info, pos, true);
        this.turnBuilder = new BuilderTurn(turnInfo, pos);
        this.turnBuilder.overrideFlexible = true;
        for (TrackBase turn : this.turnBuilder.tracks) {
            if (!(turn instanceof TrackRail)) continue;
            turn.overrideParent(new BlockPos(this.straightBuilder.mainX, 0, this.straightBuilder.mainZ));
        }
        for (TrackBase straight : this.straightBuilder.tracks) {
            if (!(straight instanceof TrackGag)) continue;
            straight.setFlexible();
        }
    }

    @Override
    public int costTies() {
        return this.straightBuilder.costTies() + this.turnBuilder.costTies();
    }

    @Override
    public int costRails() {
        return this.straightBuilder.costRails() + this.turnBuilder.costRails();
    }

    @Override
    public int costBed() {
        return this.straightBuilder.costBed() + this.turnBuilder.costBed();
    }

    @Override
    public int costFill() {
        return this.straightBuilder.costFill() + this.turnBuilder.costFill();
    }

    @Override
    public void setDrops(List<ItemStack> drops) {
        this.straightBuilder.setDrops(drops);
    }

    @Override
    public boolean canBuild() {
        return this.straightBuilder.canBuild() && this.turnBuilder.canBuild();
    }

    @Override
    public void build() {
        this.straightBuilder.build();
        this.turnBuilder.build();
    }

    @Override
    public List<TrackBase> getTracksForRender() {
        List<TrackBase> data = this.straightBuilder.getTracksForRender();
        data.addAll(this.turnBuilder.getTracksForRender());
        return data;
    }

    @Override
    public List<BuilderBase.VecYawPitch> getRenderData() {
        List<BuilderBase.VecYawPitch> data = this.straightBuilder.getRenderData();
        data.addAll(this.turnBuilder.getRenderData());
        return data;
    }

    public boolean isOnStraight(Vec3d position) {
        for (TrackBase gag : this.straightBuilder.tracks) {
            if (!gag.getPos().func_177971_a((Vec3i)new BlockPos(this.info.placementPosition)).equals((Object)new BlockPos(position))) continue;
            return true;
        }
        return false;
    }
}

