/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.track.TrackGag;
import cam72cam.immersiverailroading.track.TrackRail;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.immersiverailroading.util.VecUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public class BuilderTurn
extends BuilderBase {
    private float realStartAngle;
    private float startAngle;
    private float endAngle;
    private int mainX;
    private int mainZ;

    public BuilderTurn(RailInfo info, BlockPos pos) {
        super(info, pos);
        double radius = info.length;
        int xMult = info.direction == TrackDirection.LEFT ? -1 : 1;
        int zMult = 1;
        HashSet<Pair> positions = new HashSet<Pair>();
        HashSet<Pair> flexPositions = new HashSet<Pair>();
        double hack = -0.5;
        float angleDelta = (float)(90.0 / (Math.PI * radius / 2.0));
        this.startAngle = 90.0f - (float)info.quarter / 4.0f * 90.0f;
        this.endAngle = this.startAngle - (float)info.quarters / 4.0f * 90.0f;
        if (info.direction == TrackDirection.LEFT) {
            this.startAngle = 270.0f + (float)info.quarter / 4.0f * 90.0f;
            this.endAngle = this.startAngle + (float)info.quarters / 4.0f * 90.0f;
        }
        int xPos = (int)(Math.sin(Math.toRadians(this.startAngle)) * (radius + hack + (double)xMult));
        int zPos = (int)(Math.cos(Math.toRadians(this.startAngle)) * (radius + hack + (double)zMult));
        double xAbsPos = Math.sin(Math.toRadians(this.startAngle)) * (radius + hack);
        double zAbsPos = Math.cos(Math.toRadians(this.startAngle)) * (radius + hack);
        this.realStartAngle = this.startAngle;
        if (info.direction == TrackDirection.LEFT) {
            float tmp = this.startAngle;
            this.startAngle = this.endAngle;
            this.endAngle = tmp;
        }
        float flexAngle = 6.0f;
        for (float angle = this.startAngle; angle > this.endAngle; angle -= angleDelta) {
            for (double q = -this.gauge.value(); q <= this.gauge.value(); q += 0.1) {
                int gagX = (int)(Math.sin(Math.toRadians(angle)) * (radius + hack + q)) + 1 - xPos;
                int gagZ = (int)(Math.cos(Math.toRadians(angle)) * (radius + hack + q)) - zPos;
                positions.add(Pair.of((Object)gagX, (Object)gagZ));
                if (!(angle > this.startAngle - flexAngle) && !(angle < this.endAngle + flexAngle)) continue;
                flexPositions.add(Pair.of((Object)gagX, (Object)gagZ));
            }
            if (Math.ceil(angle) != Math.ceil((this.startAngle + this.endAngle) / 2.0f)) continue;
            this.mainX = (int)(Math.sin(Math.toRadians(angle)) * (radius + hack)) + 1 - xPos;
            this.mainZ = (int)(Math.cos(Math.toRadians(angle)) * (radius + hack)) - zPos;
        }
        this.setParentPos(new BlockPos(this.mainX, 0, this.mainZ));
        TrackRail turnTrack = new TrackRail(this, this.mainX, 0, this.mainZ, EnumFacing.NORTH, TrackItems.TURN, info.length, info.quarter, info.placementPosition);
        Vec3d center = new Vec3d(-xAbsPos, 0.0, -zAbsPos - 0.5);
        center = VecUtil.rotateYaw(center, info.facing.func_185119_l() - 90.0f);
        center = info.placementPosition.func_178787_e(center);
        turnTrack.setRotationCenter(center);
        turnTrack.setDirection(info.direction);
        turnTrack.setTurnQuarters(info.quarters);
        xMult = 1;
        this.tracks.add(turnTrack);
        for (Pair pair : positions) {
            int gagX = (Integer)pair.getLeft() * xMult;
            int gagZ = (Integer)pair.getRight() * zMult;
            if (gagX == this.mainX && gagZ == this.mainZ) continue;
            TrackGag tg = new TrackGag(this, gagX, 0, gagZ);
            if (flexPositions.contains(pair)) {
                tg.setFlexible();
            }
            this.tracks.add(tg);
        }
    }

    @Override
    public List<TrackBase> getTracksForRender() {
        return this.tracks;
    }

    @Override
    public List<BuilderBase.VecYawPitch> getRenderData() {
        ArrayList<BuilderBase.VecYawPitch> data = new ArrayList<BuilderBase.VecYawPitch>();
        float radius = this.info.length;
        float angleDelta = 90.0f / ((float)Math.PI * (radius + 1.0f) / 2.0f) * (float)this.gauge.scale();
        double hack = 0.05;
        double xPos = Math.floor(Math.sin(Math.toRadians(this.realStartAngle)) * ((double)radius + hack));
        double zPos = Math.floor(Math.cos(Math.toRadians(this.realStartAngle)) * ((double)radius + hack));
        hack = 0.7 * (this.gauge.value() - Gauge.STANDARD.value() / 2.0);
        if (this.info.direction == TrackDirection.LEFT) {
            xPos += 1.0;
            zPos += 1.0;
        } else {
            xPos -= 1.0;
        }
        xPos += 1.0 - this.gauge.scale();
        int counter = 0;
        for (float angle = this.startAngle - angleDelta / 2.0f; angle > this.endAngle - angleDelta; angle -= angleDelta) {
            double gagX = Math.sin(Math.toRadians(angle)) * ((double)radius + hack) - xPos;
            double gagZ = Math.cos(Math.toRadians(angle)) * ((double)radius + hack) - zPos;
            float switchAngle = 0.0f;
            float switchOffset = 0.0f;
            if (this.info.switchState == SwitchState.STRAIGHT) {
                if (this.info.direction == TrackDirection.RIGHT) {
                    if (angle > this.startAngle - 4.0f * angleDelta) {
                        switchOffset = (float)(4 - ++counter) / 30.0f * -((float)this.gauge.scale());
                        switchAngle = angleDelta * (float)this.info.length / 30.0f;
                    }
                } else if (angle < this.endAngle + 4.0f * angleDelta) {
                    switchOffset = (float)(++counter) / 30.0f * (float)this.gauge.scale();
                    switchAngle = -angleDelta * (float)this.info.length / 30.0f;
                }
            }
            if (switchAngle == 0.0f) {
                data.add((BuilderBase)this.new BuilderBase.VecYawPitch(gagX, 0.0, gagZ, angle + 90.0f + angleDelta / 2.0f + switchAngle, new String[0]));
                continue;
            }
            data.add((BuilderBase)this.new BuilderBase.VecYawPitch(gagX, 0.0, gagZ, angle + 90.0f + angleDelta / 2.0f, "RAIL_BASE", "RAIL_RIGHT"));
            data.add((BuilderBase)this.new BuilderBase.VecYawPitch(gagX + (double)switchOffset, 0.0, gagZ, angle + 90.0f + angleDelta / 2.0f + switchAngle, "RAIL_LEFT"));
        }
        return data;
    }
}

