/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.blocks.BlockRailBase;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class TrackBase {
    public BuilderBase builder;
    protected int rel_x;
    protected int rel_y;
    protected int rel_z;
    private EnumFacing rel_rotation;
    private float height;
    protected Block block;
    private boolean flexible = false;
    private BlockPos parent;

    public TrackBase(BuilderBase builder, int rel_x, int rel_y, int rel_z, Block block, EnumFacing rel_rotation) {
        this.builder = builder;
        this.rel_x = rel_x;
        this.rel_y = rel_y;
        this.rel_z = rel_z;
        this.rel_rotation = rel_rotation;
        this.block = block;
    }

    public boolean canPlaceTrack() {
        BuilderBase.PosRot pos = this.getPos();
        IBlockState down = this.builder.world.func_180495_p(pos.func_177977_b());
        boolean downOK = down.func_185896_q() || BlockUtil.canBeReplaced(this.builder.world, pos.func_177977_b(), false) && this.builder.info.railBedFill.func_77973_b() != Items.field_190931_a;
        return BlockUtil.canBeReplaced(this.builder.world, pos, this.flexible || this.builder.overrideFlexible) && downOK;
    }

    public TileEntity placeTrack() {
        BuilderBase.PosRot pos = this.getPos();
        if (this.builder.info.railBedFill.func_77973_b() != Items.field_190931_a && BlockUtil.canBeReplaced(this.builder.world, pos.func_177977_b(), false)) {
            this.builder.world.func_175656_a(pos.func_177977_b(), BlockUtil.itemToBlockState(this.builder.info.railBedFill));
        }
        NBTTagCompound replaced = null;
        IBlockState state = this.builder.world.func_180495_p((BlockPos)pos);
        Block removed = state.func_177230_c();
        TileRailBase te = null;
        if (removed != null) {
            if (removed instanceof BlockRailBase) {
                te = TileRailBase.get((IBlockAccess)this.builder.world, pos);
                if (te != null) {
                    replaced = te.serializeNBT();
                }
            } else {
                removed.func_176226_b(this.builder.world, (BlockPos)pos, state, 0);
            }
        }
        if (te != null) {
            te.setWillBeReplaced(true);
        }
        this.builder.world.func_180501_a((BlockPos)pos, this.getBlockState(), 3);
        if (te != null) {
            te.setWillBeReplaced(false);
        }
        TileRailBase tr = TileRailBase.get((IBlockAccess)this.builder.world, pos);
        tr.setReplaced(replaced);
        if (this.parent != null) {
            tr.setParent(this.parent);
        } else {
            tr.setParent(this.builder.getParentPos());
        }
        tr.setHeight(this.getHeight());
        return tr;
    }

    public IBlockState getBlockState() {
        return this.block.func_176223_P();
    }

    public EnumFacing getFacing() {
        return this.getPos().getRotation();
    }

    public void moveTo(TrackBase trackBase) {
        this.rel_x = trackBase.rel_x;
        this.rel_y = trackBase.rel_y;
        this.rel_z = trackBase.rel_z;
    }

    public BuilderBase.PosRot getPos() {
        return this.builder.convertRelativePositions(this.rel_x, this.rel_y, this.rel_z, this.rel_rotation);
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getHeight() {
        return this.height;
    }

    public Gauge getGauge() {
        return this.builder.gauge;
    }

    public void setFlexible() {
        this.flexible = true;
    }

    public boolean isFlexible() {
        return this.flexible;
    }

    public void overrideParent(BlockPos blockPos) {
        this.parent = this.builder.convertRelativePositions(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), this.rel_rotation);
    }
}

