/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.blocks.BlockRailBase;
import cam72cam.immersiverailroading.tile.TileRailBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import trackapi.lib.Util;

public class BlockUtil {
    public static boolean canBeReplaced(World world, BlockPos pos, boolean allowFlex) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == null) {
            return true;
        }
        if (block.func_176200_f((IBlockAccess)world, pos)) {
            return true;
        }
        if (block instanceof IGrowable && !(block instanceof BlockGrass)) {
            return true;
        }
        if (block instanceof IPlantable) {
            return true;
        }
        if (block instanceof BlockLiquid) {
            return true;
        }
        if (block instanceof BlockSnow) {
            return true;
        }
        if (block == ImmersiveRailroading.BLOCK_RAIL_PREVIEW) {
            return true;
        }
        if (allowFlex && block instanceof BlockRailBase) {
            TileRailBase te = TileRailBase.get((IBlockAccess)world, pos);
            return te != null && te.isFlexible();
        }
        return false;
    }

    public static IBlockState itemToBlockState(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        IBlockState gravelState = block.func_176203_a(stack.func_77960_j());
        if (block instanceof BlockLog) {
            gravelState = gravelState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
        }
        return gravelState;
    }

    public static boolean isIRRail(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockRailBase;
    }

    public static boolean isRail(World world, BlockPos pos) {
        return Util.getTileEntity((World)world, (Vec3d)new Vec3d((Vec3i)pos), (boolean)true) != null;
    }

    public static Rotation rotFromFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return Rotation.NONE;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }
}

