/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.Config;

public class FluidQuantity {
    public static final FluidQuantity ZERO = FluidQuantity.FromBuckets(0);
    private final int mb;

    private FluidQuantity(int mb) {
        this.mb = mb;
    }

    public static FluidQuantity FromBuckets(int buckets) {
        return new FluidQuantity(buckets * 1000);
    }

    public static FluidQuantity FromLiters(int liters) {
        return new FluidQuantity(liters * Config.MB_PER_LITER);
    }

    public static FluidQuantity FromMillibuckets(int mb) {
        return new FluidQuantity(mb);
    }

    public int Buckets() {
        return this.mb / 1000;
    }

    public int Liters() {
        return this.mb / Config.MB_PER_LITER;
    }

    public int MilliBuckets() {
        return this.mb;
    }

    public FluidQuantity scale(double scale) {
        return new FluidQuantity((int)((double)this.mb * scale));
    }

    public FluidQuantity min(FluidQuantity min) {
        if (min.mb > this.mb) {
            return min;
        }
        return this;
    }
}

