/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.items.ItemTrackBlueprint;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.BuilderCrossing;
import cam72cam.immersiverailroading.track.BuilderSlope;
import cam72cam.immersiverailroading.track.BuilderStraight;
import cam72cam.immersiverailroading.track.BuilderSwitch;
import cam72cam.immersiverailroading.track.BuilderTurn;
import cam72cam.immersiverailroading.util.BlockUtil;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class RailInfo {
    public BlockPos position;
    public World world;
    public EnumFacing facing;
    public TrackItems type;
    public TrackDirection direction;
    public int length;
    public int quarter;
    public int quarters;
    public Gauge gauge;
    public Vec3d placementPosition;
    public ItemStack railBed;
    public ItemStack railBedFill;
    public boolean snowRenderFlagDirty = false;
    public SwitchState switchState = SwitchState.NONE;
    private BuilderBase builder;

    public RailInfo(BlockPos position, World world, EnumFacing facing, TrackItems type, TrackDirection direction, int length, int quarter, int quarters, Gauge gauge, Vec3d placementPosition, ItemStack railBed, ItemStack railBedFill) {
        this.position = position;
        this.world = world;
        this.facing = facing;
        this.type = type;
        this.direction = direction;
        this.length = length;
        this.quarter = quarter;
        this.quarters = quarters;
        this.gauge = gauge;
        this.placementPosition = placementPosition;
        this.railBed = railBed;
        this.railBedFill = railBedFill;
    }

    public RailInfo(ItemStack stack, World worldIn, float yawHead, BlockPos pos, float hitX, float hitY, float hitZ) {
        this.position = pos;
        this.type = ItemTrackBlueprint.getType(stack);
        this.length = ItemTrackBlueprint.getLength(stack);
        this.quarters = ItemTrackBlueprint.getQuarters(stack);
        this.gauge = ItemGauge.get(stack);
        this.railBed = ItemTrackBlueprint.getBed(stack);
        this.railBedFill = ItemTrackBlueprint.getBedFill(stack);
        this.world = worldIn;
        TrackPositionType posType = ItemTrackBlueprint.getPosType(stack);
        yawHead = yawHead % 360.0f + 360.0f;
        this.direction = yawHead % 90.0f < 45.0f ? TrackDirection.RIGHT : TrackDirection.LEFT;
        float yawPartial = (yawHead + 3600.0f) % 90.0f;
        if (this.direction == TrackDirection.LEFT) {
            yawPartial = 90.0f - yawPartial;
        }
        this.quarter = yawPartial < 15.0f ? 0 : (yawPartial < 30.0f ? 1 : 2);
        this.facing = EnumFacing.func_176733_a((double)yawHead);
        switch (posType) {
            case FIXED: {
                hitX = 0.5f;
                hitZ = 0.5f;
                break;
            }
            case PIXELS: {
                hitX = (float)((int)(hitX * 16.0f)) / 16.0f;
                hitZ = (float)((int)(hitZ * 16.0f)) / 16.0f;
                break;
            }
        }
        this.placementPosition = new Vec3d((Vec3i)pos).func_72441_c((double)hitX, 0.0, (double)hitZ);
        if (BlockUtil.canBeReplaced(this.world, pos.func_177977_b(), true)) {
            pos = pos.func_177977_b();
        }
    }

    public RailInfo clone() {
        RailInfo c = new RailInfo(this.position, this.world, this.facing, this.type, this.direction, this.length, this.quarter, this.quarters, this.gauge, this.placementPosition, this.railBed, this.railBedFill);
        return c;
    }

    public BuilderBase getBuilder(BlockPos pos) {
        switch (this.type) {
            case STRAIGHT: {
                return new BuilderStraight(this, pos);
            }
            case CROSSING: {
                return new BuilderCrossing(this, pos);
            }
            case SLOPE: {
                return new BuilderSlope(this, pos);
            }
            case TURN: {
                return new BuilderTurn(this, pos);
            }
            case SWITCH: {
                return new BuilderSwitch(this, pos);
            }
        }
        return null;
    }

    public BuilderBase getBuilder() {
        if (this.builder == null) {
            this.builder = this.getBuilder(new BlockPos(0, 0, 0));
        }
        return this.builder;
    }

    public boolean build(EntityPlayer player, BlockPos pos) {
        BuilderBase builder = this.getBuilder(pos);
        if (builder.canBuild() && !this.world.field_72995_K) {
            if (player.func_184812_l_()) {
                builder.build();
                return true;
            }
            int ties = 0;
            int rails = 0;
            int bed = 0;
            int fill = 0;
            for (ItemStack playerStack : player.field_71071_by.field_70462_a) {
                if (playerStack.func_77973_b() == ImmersiveRailroading.ITEM_RAIL && ItemGauge.get(playerStack) == builder.gauge) {
                    rails += playerStack.func_190916_E();
                }
                if (this.OreDictionaryContainsMatch(false, (NonNullList<ItemStack>)OreDictionary.getOres((String)"plankTreatedWood"), playerStack)) {
                    ties += playerStack.func_190916_E();
                }
                if (this.railBed.func_77973_b() != Items.field_190931_a && this.railBed.func_77973_b() == playerStack.func_77973_b() && this.railBed.func_77960_j() == playerStack.func_77960_j()) {
                    bed += playerStack.func_190916_E();
                }
                if (this.railBedFill.func_77973_b() == Items.field_190931_a || this.railBedFill.func_77973_b() != playerStack.func_77973_b() || this.railBedFill.func_77960_j() != playerStack.func_77960_j()) continue;
                fill += playerStack.func_190916_E();
            }
            if (ties < builder.costTies()) {
                player.func_145747_a((ITextComponent)ChatText.BUILD_MISSING_TIES.getMessage(builder.costTies() - ties));
                return false;
            }
            if (rails < builder.costRails()) {
                player.func_145747_a((ITextComponent)ChatText.BUILD_MISSING_RAILS.getMessage(builder.costRails() - rails));
                return false;
            }
            if (this.railBed.func_77973_b() != Items.field_190931_a && bed < builder.costBed()) {
                player.func_145747_a((ITextComponent)ChatText.BUILD_MISSING_RAIL_BED.getMessage(builder.costBed() - bed));
                return false;
            }
            if (this.railBedFill.func_77973_b() != Items.field_190931_a && fill < builder.costFill()) {
                player.func_145747_a((ITextComponent)ChatText.BUILD_MISSING_RAIL_BED_FILL.getMessage(builder.costFill() - fill));
                return false;
            }
            ties = builder.costTies();
            rails = builder.costRails();
            bed = builder.costBed();
            fill = builder.costFill();
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (ItemStack playerStack : player.field_71071_by.field_70462_a) {
                ItemStack copy;
                if (playerStack.func_77973_b() == ImmersiveRailroading.ITEM_RAIL && ItemGauge.get(playerStack) == builder.gauge) {
                    if (rails > playerStack.func_190916_E()) {
                        rails -= playerStack.func_190916_E();
                        copy = playerStack.func_77946_l();
                        copy.func_190920_e(playerStack.func_190916_E());
                        drops.add(copy);
                        playerStack.func_190920_e(0);
                    } else if (rails != 0) {
                        copy = playerStack.func_77946_l();
                        copy.func_190920_e(rails);
                        drops.add(copy);
                        playerStack.func_190920_e(playerStack.func_190916_E() - rails);
                        rails = 0;
                    }
                }
                if (this.OreDictionaryContainsMatch(false, (NonNullList<ItemStack>)OreDictionary.getOres((String)"plankTreatedWood"), playerStack)) {
                    if (ties > playerStack.func_190916_E()) {
                        ties -= playerStack.func_190916_E();
                        copy = playerStack.func_77946_l();
                        copy.func_190920_e(playerStack.func_190916_E());
                        drops.add(copy);
                        playerStack.func_190920_e(0);
                    } else if (ties != 0) {
                        copy = playerStack.func_77946_l();
                        copy.func_190920_e(ties);
                        drops.add(copy);
                        playerStack.func_190920_e(playerStack.func_190916_E() - ties);
                        ties = 0;
                    }
                }
                if (this.railBed.func_77973_b() != Items.field_190931_a && this.railBed.func_77973_b() == playerStack.func_77973_b() && this.railBed.func_77960_j() == playerStack.func_77960_j()) {
                    if (bed > playerStack.func_190916_E()) {
                        bed -= playerStack.func_190916_E();
                        copy = playerStack.func_77946_l();
                        copy.func_190920_e(playerStack.func_190916_E());
                        drops.add(copy);
                        playerStack.func_190920_e(0);
                    } else if (bed != 0) {
                        copy = playerStack.func_77946_l();
                        copy.func_190920_e(bed);
                        drops.add(copy);
                        playerStack.func_190920_e(playerStack.func_190916_E() - bed);
                        bed = 0;
                    }
                }
                if (this.railBedFill.func_77973_b() == Items.field_190931_a || this.railBedFill.func_77973_b() != playerStack.func_77973_b() || this.railBedFill.func_77960_j() != playerStack.func_77960_j()) continue;
                if (fill > playerStack.func_190916_E()) {
                    fill -= playerStack.func_190916_E();
                    copy = playerStack.func_77946_l();
                    copy.func_190920_e(playerStack.func_190916_E());
                    playerStack.func_190920_e(0);
                    continue;
                }
                if (fill == 0) continue;
                copy = playerStack.func_77946_l();
                copy.func_190920_e(fill);
                playerStack.func_190920_e(playerStack.func_190916_E() - fill);
                fill = 0;
            }
            builder.setDrops(drops);
            builder.build();
            return true;
        }
        return false;
    }

    private boolean OreDictionaryContainsMatch(boolean strict, NonNullList<ItemStack> ores, ItemStack playerStack) {
        for (ItemStack target : ores) {
            if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)playerStack, (boolean)strict)) continue;
            return true;
        }
        return false;
    }
}

