/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.util.VecUtil;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class RealBB
extends AxisAlignedBB {
    private double front;
    private double rear;
    private double width;
    private double height;
    private float yaw;
    private double centerX;
    private double centerY;
    private double centerZ;

    public RealBB(double front, double rear, double width, double height, float yaw) {
        this(front, rear, width, height, yaw, 0.0, 0.0, 0.0);
    }

    private RealBB(double front, double rear, double width, double height, float yaw, double centerX, double centerY, double centerZ) {
        this(RealBB.constructorParams(front, rear, width, height, yaw, centerX, centerY, centerZ));
        this.front = front;
        this.rear = rear;
        this.width = width;
        this.height = height;
        this.yaw = yaw;
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
    }

    private RealBB(double[] constructorParams) {
        super(constructorParams[0], constructorParams[1], constructorParams[2], constructorParams[3], constructorParams[4], constructorParams[5]);
    }

    private static AxisAlignedBB newBB(Vec3d min, Vec3d max) {
        return new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    private static double[] constructorParams(double front, double rear, double width, double height, float yaw, double centerX, double centerY, double centerZ) {
        Vec3d frontPos = VecUtil.fromYaw(front, yaw);
        Vec3d rearPos = VecUtil.fromYaw(rear, yaw);
        Vec3d offsetRight = VecUtil.fromYaw(width / 2.0, yaw + 90.0f);
        Vec3d offsetLeft = VecUtil.fromYaw(width / 2.0, yaw - 90.0f);
        AxisAlignedBB rightBox = RealBB.newBB(frontPos.func_178787_e(offsetRight), rearPos.func_178787_e(offsetRight));
        AxisAlignedBB leftBox = RealBB.newBB(frontPos.func_178787_e(offsetLeft), rearPos.func_178787_e(offsetLeft));
        AxisAlignedBB newthis = rightBox.func_111270_a(leftBox).func_72317_d(centerX, centerY, centerZ);
        return new double[]{newthis.field_72336_d, newthis.field_72337_e + height, newthis.field_72334_f, newthis.field_72340_a, newthis.field_72338_b, newthis.field_72339_c};
    }

    public RealBB clone() {
        return new RealBB(this.front, this.rear, this.width, this.height, this.yaw, this.centerX, this.centerY, this.centerZ);
    }

    public AxisAlignedBB func_186666_e(double y2) {
        return this.clone();
    }

    public AxisAlignedBB func_191195_a(double x, double y, double z) {
        RealBB expanded = this.clone();
        if (x > 0.0) {
            expanded.front -= x;
        } else {
            expanded.rear -= x;
        }
        if (y > 0.0) {
            expanded.height -= y;
        } else {
            expanded.centerY -= y;
        }
        expanded.width -= z;
        return expanded.clone();
    }

    public AxisAlignedBB func_72321_a(double x, double y, double z) {
        RealBB expanded = this.clone();
        if (x > 0.0) {
            expanded.front += x;
        } else {
            expanded.rear += x;
        }
        if (y > 0.0) {
            expanded.height += y;
        } else {
            expanded.centerY += y;
        }
        expanded.width += z;
        return expanded.clone();
    }

    public AxisAlignedBB func_72314_b(double x, double y, double z) {
        RealBB growed = this.clone();
        growed.front += x;
        growed.rear += x;
        growed.height += y;
        growed.centerY += y;
        growed.width += z + z;
        return growed;
    }

    public AxisAlignedBB func_191500_a(AxisAlignedBB p_191500_1_) {
        return this.clone();
    }

    public AxisAlignedBB func_111270_a(AxisAlignedBB other) {
        return this.clone();
    }

    public AxisAlignedBB func_186670_a(BlockPos pos) {
        return this.func_72317_d(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public AxisAlignedBB func_191194_a(Vec3d vec) {
        return this.func_72317_d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public AxisAlignedBB func_72317_d(double x, double y, double z) {
        RealBB offsetted = this.clone();
        offsetted.centerX += x;
        offsetted.centerY += y;
        offsetted.centerZ += z;
        return offsetted.clone();
    }

    public double func_72316_a(AxisAlignedBB other, double offsetX) {
        return 0.0;
    }

    public double func_72323_b(AxisAlignedBB other, double offsetY) {
        if (other.field_72338_b < this.field_72337_e) {
            return 0.1;
        }
        return 0.0;
    }

    public double func_72322_c(AxisAlignedBB other, double offsetZ) {
        return 0.0;
    }

    public boolean func_186668_a(double x1, double y1, double z1, double x2, double y2, double z2) {
        boolean doesIntersect = true;
        double actualYMin = this.centerY;
        double actualYMax = this.centerY + this.height;
        doesIntersect = doesIntersect && actualYMin < y2 && actualYMax > y1;
        Vec3d origin = VecUtil.rotateYaw(new Vec3d(this.rear, 0.0, -this.width / 2.0), this.yaw).func_72441_c(this.centerX, 0.0, this.centerZ);
        Vec3d point1 = VecUtil.fromYaw(this.front - this.rear, this.yaw).func_178787_e(origin);
        Vec3d point2 = VecUtil.fromYaw(this.width, this.yaw + 90.0f).func_178787_e(origin);
        Vec3d opposite = VecUtil.rotateYaw(new Vec3d(this.front, 0.0, this.width / 2.0), this.yaw).func_72441_c(this.centerX, 0.0, this.centerZ);
        int[] xp = new int[]{(int)(100.0 * origin.field_72450_a), (int)(100.0 * point1.field_72450_a), (int)(100.0 * opposite.field_72450_a), (int)(100.0 * point2.field_72450_a)};
        int[] zp = new int[]{(int)(100.0 * origin.field_72449_c), (int)(100.0 * point1.field_72449_c), (int)(100.0 * opposite.field_72449_c), (int)(100.0 * point2.field_72449_c)};
        Polygon rect = new Polygon(xp, zp, 4);
        if (x1 == x2 && y1 == y2 && z1 == z2) {
            doesIntersect = doesIntersect && rect.contains(x1 * 100.0, z1 * 100.0);
        } else {
            Rectangle2D.Double r = new Rectangle2D.Double(x1 * 100.0, z1 * 100.0, 0.0, 0.0);
            r.add(x2 * 100.0, z2 * 100.0);
            doesIntersect = doesIntersect && rect.intersects(r);
        }
        return doesIntersect;
    }

    public boolean func_72318_a(Vec3d vec) {
        return this.func_186668_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public RayTraceResult func_72327_a(Vec3d vecA, Vec3d vecB) {
        int steps = 10;
        double xDist = vecB.field_72450_a - vecA.field_72450_a;
        double yDist = vecB.field_72448_b - vecA.field_72448_b;
        double zDist = vecB.field_72449_c - vecA.field_72449_c;
        double xDelta = xDist / (double)steps;
        double yDelta = yDist / (double)steps;
        double zDelta = zDist / (double)steps;
        for (int step = 0; step < steps; ++step) {
            Vec3d stepPos = new Vec3d(vecA.field_72450_a + xDelta * (double)step, vecA.field_72448_b + yDelta * (double)step, vecA.field_72449_c + zDelta * (double)step);
            if (!this.func_72318_a(stepPos)) continue;
            return new RayTraceResult(stepPos, EnumFacing.UP);
        }
        return null;
    }
}

