/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.track.BuilderSwitch;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class SwitchUtil {
    public static SwitchState getSwitchState(TileRail rail) {
        return SwitchUtil.getSwitchState(rail, null);
    }

    public static SwitchState getSwitchState(TileRail rail, Vec3d position) {
        BuilderSwitch switchBuilder;
        if (rail == null) {
            return SwitchState.NONE;
        }
        if (!rail.isLoaded()) {
            return SwitchState.NONE;
        }
        TileRail parent = rail.getParentTile();
        if (parent == null || !parent.isLoaded()) {
            return SwitchState.NONE;
        }
        if (rail.getType() != TrackItems.TURN) {
            return SwitchState.NONE;
        }
        if (parent.getType() != TrackItems.SWITCH) {
            return SwitchState.NONE;
        }
        if (position != null && parent.getRailRenderInfo() != null && !(switchBuilder = (BuilderSwitch)parent.getRailRenderInfo().getBuilder()).isOnStraight(position)) {
            return SwitchState.TURN;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (rail.func_145831_w().func_175687_A(new BlockPos(rail.getPlacementPosition()).func_177967_a(facing, MathHelper.func_76143_f((double)rail.getGauge().scale()))) <= 0) continue;
            return SwitchState.TURN;
        }
        return SwitchState.STRAIGHT;
    }
}

