/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class VecUtil {
    private VecUtil() {
    }

    public static Vec3d fromYaw(double distance, float yaw) {
        return new Vec3d(-Math.sin(Math.toRadians(yaw)) * distance, 0.0, Math.cos(Math.toRadians(yaw)) * distance);
    }

    public static float toYaw(Vec3d delta) {
        float yaw = (float)Math.toDegrees(MathHelper.func_181159_b((double)(-delta.field_72450_a), (double)delta.field_72449_c));
        return (yaw + 360.0f) % 360.0f;
    }

    public static Vec3d rotateYaw(Vec3d pos, float rotationYaw) {
        return VecUtil.fromYaw(pos.field_72450_a, rotationYaw).func_178787_e(VecUtil.fromYaw(pos.field_72449_c, rotationYaw + 90.0f).func_72441_c(0.0, pos.field_72448_b, 0.0));
    }

    public static BlockPos rotateYaw(BlockPos pos, float rotationYaw) {
        return new BlockPos(VecUtil.rotateYaw(new Vec3d((Vec3i)pos), rotationYaw));
    }

    public static Vec3d fromYawPitch(float distance, float rotationYaw, float rotationPitch) {
        return VecUtil.fromYaw(distance, rotationYaw).func_72441_c(0.0, Math.tan(Math.toRadians(rotationPitch)) * (double)distance, 0.0);
    }

    public static Vec3d between(Vec3d front, Vec3d rear) {
        return new Vec3d((front.field_72450_a + rear.field_72450_a) / 2.0, (front.field_72448_b + rear.field_72448_b) / 2.0, (front.field_72449_c + rear.field_72449_c) / 2.0);
    }
}

