/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation;

import com.google.common.collect.ArrayListMultimap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ModelProcessor {
    public static void main(String[] args) {
        String modid = "refinedrelocation";
        File inputDir = new File("./models/");
        File outputDir = new File("./src/main/resources/assets/refinedrelocation/models/block/");
        ModelProcessor.fixTextures(inputDir, "refinedrelocation");
        ModelProcessor.generateModels(inputDir, outputDir);
    }

    private static void fixTextures(File inputDir, final String modId) {
        final Gson gson = new Gson();
        try {
            Files.walkFileTree(inputDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    block26: {
                        if (file.toFile().getName().endsWith(".json")) {
                            try (FileReader reader = new FileReader(file.toFile());){
                                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                                JsonObject textures = json.getAsJsonObject("textures");
                                if (textures == null) break block26;
                                for (Map.Entry entry : textures.entrySet()) {
                                    if (((JsonElement)entry.getValue()).getAsString().startsWith(modId + ":")) continue;
                                    textures.addProperty((String)entry.getKey(), modId + ":" + ((JsonElement)entry.getValue()).getAsString());
                                }
                                try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(file.toFile()));){
                                    gson.toJson((JsonElement)json, writer);
                                }
                            }
                        }
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void generateModels(File inputDir, final File outputDir) {
        try {
            FileUtils.deleteDirectory((File)outputDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        outputDir.mkdirs();
        final Gson gson = new Gson();
        try {
            Files.walkFileTree(inputDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toFile().getName().endsWith("_full.json")) {
                        try (FileReader reader = new FileReader(file.toFile());){
                            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                            ArrayListMultimap modelParts = ArrayListMultimap.create();
                            for (JsonElement element : jsonObject.getAsJsonArray("elements")) {
                                String partName;
                                int idx;
                                JsonObject obj = element.getAsJsonObject();
                                if (!obj.has("__comment") || (idx = (partName = obj.get("__comment").getAsString()).indexOf(95)) == -1) continue;
                                modelParts.put((Object)partName.substring(0, idx), (Object)obj);
                            }
                            for (String subName : modelParts.keySet()) {
                                JsonObject newObject = new JsonObject();
                                newObject.addProperty("__comment", jsonObject.get("__comment").getAsString() + " (Sub Model: " + subName + ")");
                                newObject.add("textures", (JsonElement)jsonObject.getAsJsonObject("textures"));
                                JsonArray elements = new JsonArray();
                                for (JsonElement element : modelParts.get((Object)subName)) {
                                    elements.add(element);
                                }
                                newObject.add("elements", (JsonElement)elements);
                                JsonWriter writer = new JsonWriter((Writer)new FileWriter(new File(outputDir, file.toFile().getName().substring(0, file.toFile().getName().length() - 10) + subName + ".json")));
                                Throwable throwable = null;
                                try {
                                    gson.toJson((JsonElement)newObject, writer);
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (writer == null) continue;
                                    if (throwable != null) {
                                        try {
                                            writer.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    writer.close();
                                }
                            }
                        }
                    }
                    if (file.toFile().getName().endsWith(".json")) {
                        Files.copy(file, outputDir.toPath().resolve(file.getFileName()), new CopyOption[0]);
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

