/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.block;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.RefinedRelocation;
import net.blay09.mods.refinedrelocation.block.BlockModTile;
import net.blay09.mods.refinedrelocation.network.MessageOpenGui;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.blay09.mods.refinedrelocation.util.RelativeSide;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockBlockExtender
extends BlockModTile {
    public static final String name = "block_extender";
    public static final ResourceLocation registryName = new ResourceLocation("refinedrelocation", "block_extender");

    public BlockBlockExtender() {
        super(Material.field_151573_f);
        this.func_149663_c(registryName.toString());
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(3.0f);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, placer, itemStack);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileBlockExtender) {
            TileBlockExtender blockExtender = (TileBlockExtender)tileEntity;
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)DIRECTION);
            for (RelativeSide side : RelativeSide.values()) {
                if (side == RelativeSide.FRONT) continue;
                blockExtender.setSideMapping(side, facing);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            RefinedRelocation.proxy.openGui(player, new MessageOpenGui(5, pos, facing.func_176745_a()));
        }
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)).ordinal();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)DIRECTION, (Comparable)facing.func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIRECTION});
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileBlockExtender();
    }
}

