/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.block;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.RefinedRelocation;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.block.BlockModTile;
import net.blay09.mods.refinedrelocation.network.MessageOpenGui;
import net.blay09.mods.refinedrelocation.tile.TileFastHopper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFastHopper
extends BlockModTile {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", facing -> facing != EnumFacing.UP);
    public static final String name = "fast_hopper";
    public static final ResourceLocation registryName = new ResourceLocation("refinedrelocation", "fast_hopper");
    private static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");
    private static final AxisAlignedBB[] BOUNDING_BOX = new AxisAlignedBB[]{new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375), new AxisAlignedBB(0.0625, 0.625, 0.0625, 0.9375, 1.0, 0.9375), new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.625, 0.75)};
    private static final AxisAlignedBB[] BOUNDING_BOX_FACING = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.25, 0.625), null, new AxisAlignedBB(0.375, 0.25, 0.0, 0.625, 0.5, 0.25), new AxisAlignedBB(0.375, 0.25, 0.75, 0.625, 0.5, 1.0), new AxisAlignedBB(0.0, 0.25, 0.375, 0.25, 0.5, 0.625), new AxisAlignedBB(0.75, 0.25, 0.375, 1.0, 0.5, 0.625)};
    private int rayTracePass;

    public BlockFastHopper() {
        super(Material.field_151573_f);
        this.func_149663_c(registryName.toString());
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(8.0f);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.rayTracePass == 3) {
            return BOUNDING_BOX_FACING[((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal()];
        }
        return BOUNDING_BOX[this.rayTracePass];
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing opposite = facing.func_176734_d();
        if (opposite == EnumFacing.UP) {
            opposite = EnumFacing.DOWN;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)opposite).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileFastHopper();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ENABLED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf((meta & 8) != 8));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (!((Boolean)state.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    @Nullable
    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        return new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.DOWN};
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceResult[] mops = new RayTraceResult[8];
        for (int i = 1; i <= 3; ++i) {
            this.rayTracePass = i;
            mops[i] = super.func_180636_a(state, world, pos, start, end);
        }
        this.rayTracePass = 0;
        RayTraceResult maxMop = null;
        double maxDist = 0.0;
        for (RayTraceResult mop : mops) {
            double dist;
            if (mop == null || !((dist = mop.field_72307_f.func_72436_e(end)) > maxDist)) continue;
            maxMop = mop;
            maxDist = dist;
        }
        return maxMop;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.updateState(state, world, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (this.tryNameBlock(player, heldItem, (IBlockAccess)world, pos)) {
                return true;
            }
            if (player.func_70093_af()) {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity != null) {
                    RefinedRelocationAPI.openRootFilterGui(player, tileEntity);
                }
            } else {
                RefinedRelocation.proxy.openGui(player, new MessageOpenGui(4, pos));
            }
            return true;
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.updateState(world.func_180495_p(pos), world, pos);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    private void updateState(IBlockState state, World world, BlockPos pos) {
        boolean isEnabled;
        boolean bl = isEnabled = !world.func_175640_z(pos);
        if (isEnabled != (Boolean)state.func_177229_b((IProperty)ENABLED)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(isEnabled)), 4);
        }
    }
}

