/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.block;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.RefinedRelocation;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.tile.TileSortingConnector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSortingConnector
extends BlockContainer {
    public static final String name = "sorting_connector";
    public static final ResourceLocation registryName = new ResourceLocation("refinedrelocation", "sorting_connector");
    private static Map<BlockPos, IBlockState> boundingBoxCache = Maps.newHashMap();
    private static final AxisAlignedBB BOUNDING_BOX_CENTER = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB[] BOUNDING_BOX = new AxisAlignedBB[]{new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.3125, 0.6875), new AxisAlignedBB(0.3125, 0.6875, 0.3125, 0.6875, 1.0, 0.6875), new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.3125), new AxisAlignedBB(0.3125, 0.3125, 0.6875, 0.6875, 0.6875, 1.0), new AxisAlignedBB(0.0, 0.3125, 0.3125, 0.3125, 0.6875, 0.6875), new AxisAlignedBB(0.6875, 0.3125, 0.3125, 1.0, 0.6875, 0.6875)};
    private static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    private static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    private static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    private static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    private static final PropertyBool CORNER = PropertyBool.func_177716_a((String)"corner");
    public static final PropertyBool[] CONNECTIONS = new PropertyBool[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};

    public BlockSortingConnector() {
        super(Material.field_151573_f);
        this.func_149663_c(registryName.toString());
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.3f);
        this.func_149647_a(RefinedRelocation.creativeTab);
        IBlockState state = this.field_176227_L.func_177621_b();
        for (PropertyBool property : CONNECTIONS) {
            state = state.func_177226_a((IProperty)property, (Comparable)Boolean.valueOf(false));
        }
        this.func_180632_j(state);
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileSortingConnector();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState actualState = boundingBoxCache.computeIfAbsent(pos, p -> this.func_176221_a(state, source, (BlockPos)p));
        AxisAlignedBB boundingBox = BOUNDING_BOX_CENTER;
        for (int i = 0; i < CONNECTIONS.length; ++i) {
            PropertyBool property = CONNECTIONS[i];
            if (!((Boolean)actualState.func_177229_b((IProperty)property)).booleanValue()) continue;
            boundingBox = boundingBox.func_111270_a(BOUNDING_BOX[i]);
        }
        return boundingBox;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST, CORNER});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        boundingBoxCache.remove(pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        IBlockState newState = this.getConnectionState((IBlockAccess)world, pos, state);
        if (newState != state) {
            world.func_180501_a(pos, newState, 3);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getConnectionState(world, pos, state);
        boundingBoxCache.put(pos, actualState);
        return actualState;
    }

    private IBlockState getConnectionState(IBlockAccess world, BlockPos pos, IBlockState state) {
        EnumFacing.Axis axis = null;
        boolean isCorner = false;
        int connectionCount = 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos neighbourPos = pos.func_177972_a(facing);
            TileEntity tileEntity = world.func_175625_s(neighbourPos);
            if (tileEntity != null && tileEntity.hasCapability(Capabilities.SORTING_GRID_MEMBER, facing.func_176734_d())) {
                state = state.func_177226_a((IProperty)CONNECTIONS[facing.func_176745_a()], (Comparable)Boolean.valueOf(true));
                if (axis != null && axis != facing.func_176740_k()) {
                    isCorner = true;
                }
                axis = facing.func_176740_k();
                ++connectionCount;
                continue;
            }
            state = state.func_177226_a((IProperty)CONNECTIONS[facing.func_176745_a()], (Comparable)Boolean.valueOf(false));
        }
        if (connectionCount == 1) {
            isCorner = true;
        }
        return state.func_177226_a((IProperty)CORNER, (Comparable)Boolean.valueOf(isCorner));
    }
}

