/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui;

import java.util.List;
import net.blay09.mods.refinedrelocation.ModItems;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.client.gui.base.GuiContainerMod;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiTextButton;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiButtonBlockExtenderFilter;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiButtonStackLimiter;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiSideButton;
import net.blay09.mods.refinedrelocation.container.ContainerBlockExtender;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.blay09.mods.refinedrelocation.util.RelativeSide;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class GuiBlockExtender
extends GuiContainerMod<ContainerBlockExtender> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("refinedrelocation", "textures/gui/block_extender.png");
    private static final int UPDATE_INTERVAL = 20;
    private final TileBlockExtender tileEntity;
    private final GuiButtonStackLimiter btnStackLimiter;
    private final GuiButtonBlockExtenderFilter btnInputFilter;
    private final GuiButtonBlockExtenderFilter btnOutputFilter;
    private final GuiTextButton btnSlotLock;
    private int stackLimiterIdx;
    private int slotLockIdx;
    private int inputFilterIdx;
    private int outputFilterIdx;
    private int ticksSinceUpdate;
    private int lastSentStackLimit;

    public GuiBlockExtender(EntityPlayer player, TileBlockExtender tileEntity, EnumFacing clickedFace) {
        super(new ContainerBlockExtender(player, tileEntity));
        RelativeSide leftFace;
        this.tileEntity = tileEntity;
        this.field_147000_g = 176;
        RelativeSide centerFace = RelativeSide.fromFacing(tileEntity.getFacing(), clickedFace);
        RelativeSide topFace = RelativeSide.TOP;
        if (clickedFace.func_176740_k() == EnumFacing.Axis.Y) {
            centerFace = RelativeSide.FRONT;
            topFace = RelativeSide.TOP;
            leftFace = RelativeSide.LEFT;
        } else if (tileEntity.getFacing().func_176740_k() == EnumFacing.Axis.Y) {
            RelativeSide relativeSide = leftFace = clickedFace.func_176740_k() == EnumFacing.Axis.Z ? centerFace.rotateX() : centerFace.rotateX().getOpposite();
            if (tileEntity.getFacing().func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                leftFace = leftFace.getOpposite();
                topFace = RelativeSide.FRONT;
            } else {
                topFace = RelativeSide.BACK;
            }
        } else {
            leftFace = centerFace.rotateY();
        }
        this.rootNode.addChild(new GuiSideButton(9, 40, tileEntity, leftFace));
        this.rootNode.addChild(new GuiSideButton(26, 40, tileEntity, centerFace));
        this.rootNode.addChild(new GuiSideButton(43, 40, tileEntity, leftFace.getOpposite()));
        this.rootNode.addChild(new GuiSideButton(60, 40, tileEntity, centerFace.getOpposite()));
        this.rootNode.addChild(new GuiSideButton(26, 23, tileEntity, topFace));
        this.rootNode.addChild(new GuiSideButton(26, 57, tileEntity, topFace.getOpposite()));
        this.btnStackLimiter = new GuiButtonStackLimiter(0, 0, 24, 16, tileEntity);
        this.btnStackLimiter.setVisible(false);
        this.rootNode.addChild(this.btnStackLimiter);
        this.btnInputFilter = new GuiButtonBlockExtenderFilter(0, 0, 64, 16, tileEntity, false);
        this.btnInputFilter.setVisible(false);
        this.rootNode.addChild(this.btnInputFilter);
        this.btnOutputFilter = new GuiButtonBlockExtenderFilter(0, 0, 64, 16, tileEntity, true);
        this.btnOutputFilter.setVisible(false);
        this.rootNode.addChild(this.btnOutputFilter);
        this.btnSlotLock = new GuiTextButton(0, 0, 64, 16, I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.slot_lock", (Object[])new Object[0])){

            @Override
            public void addTooltip(List<String> list) {
                super.addTooltip(list);
                list.add(I18n.func_135052_a((String)"tooltip.refinedrelocation:slot_lock", (Object[])new Object[0]));
            }
        };
        this.btnSlotLock.setVisible(false);
        this.btnSlotLock.setEnabled(false);
        this.rootNode.addChild(this.btnSlotLock);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.stackLimiterIdx = -1;
        this.slotLockIdx = -1;
        this.inputFilterIdx = -1;
        this.outputFilterIdx = -1;
        for (int i = 0; i < 3; ++i) {
            ItemStack itemStack = ((ContainerBlockExtender)this.container).getUpgradeSlot(i).func_75211_c();
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77973_b() == ModItems.stackLimiter) {
                this.stackLimiterIdx = i;
                continue;
            }
            if (itemStack.func_77973_b() == ModItems.slotLock) {
                this.slotLockIdx = i;
                continue;
            }
            if (itemStack.func_77973_b() == ModItems.inputFilter) {
                this.inputFilterIdx = i;
                continue;
            }
            if (itemStack.func_77973_b() != ModItems.outputFilter) continue;
            this.outputFilterIdx = i;
        }
        this.btnStackLimiter.setVisible(this.stackLimiterIdx != -1);
        this.btnStackLimiter.setPosition(152 - this.btnStackLimiter.getWidth() - 3, 22 + this.stackLimiterIdx * 18);
        this.btnSlotLock.setVisible(this.slotLockIdx != -1);
        this.btnSlotLock.setPosition(152 - this.btnSlotLock.getWidth() - 3, 22 + this.slotLockIdx * 18);
        this.btnInputFilter.setVisible(this.inputFilterIdx != -1);
        this.btnInputFilter.setPosition(152 - this.btnInputFilter.getWidth() - 3, 22 + this.inputFilterIdx * 18);
        this.btnOutputFilter.setVisible(this.outputFilterIdx != -1);
        this.btnOutputFilter.setPosition(152 - this.btnOutputFilter.getWidth() - 3, 22 + this.outputFilterIdx * 18);
        ++this.ticksSinceUpdate;
        if (this.ticksSinceUpdate >= 20) {
            if (this.lastSentStackLimit != this.tileEntity.getStackLimiterLimit()) {
                RefinedRelocationAPI.sendContainerMessageToServer("StackLimiter", this.tileEntity.getStackLimiterLimit());
                this.lastSentStackLimit = this.tileEntity.getStackLimiterLimit();
            }
            this.ticksSinceUpdate = 0;
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        ItemStack mouseStack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (!mouseStack.func_190926_b()) {
            int conflictSlot = -1;
            if (mouseStack.func_77973_b() == ModItems.stackLimiter && this.stackLimiterIdx != -1) {
                conflictSlot = this.stackLimiterIdx;
            } else if (mouseStack.func_77973_b() == ModItems.slotLock && this.slotLockIdx != -1) {
                conflictSlot = this.slotLockIdx;
            } else if (mouseStack.func_77973_b() == ModItems.inputFilter && this.inputFilterIdx != -1) {
                conflictSlot = this.inputFilterIdx;
            } else if (mouseStack.func_77973_b() == ModItems.outputFilter && this.outputFilterIdx != -1) {
                conflictSlot = this.outputFilterIdx;
            }
            if (conflictSlot != -1) {
                Slot slot = ((ContainerBlockExtender)this.container).getUpgradeSlot(conflictSlot);
                Gui.func_73734_a((int)(this.field_147003_i + slot.field_75223_e), (int)(this.field_147009_r + slot.field_75221_f), (int)(this.field_147003_i + slot.field_75223_e + 16), (int)(this.field_147009_r + slot.field_75221_f + 16), (int)0x55FF0000);
            }
        }
        super.func_146976_a(partialTicks, mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.tileEntity.func_145748_c_().func_150260_c(), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    @Override
    public boolean onGuiAboutToClose() {
        RefinedRelocationAPI.sendContainerMessageToServer("StackLimiter", this.tileEntity.getStackLimiterLimit());
        return true;
    }
}

