/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import java.util.Arrays;
import java.util.List;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiTextButton;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class GuiButtonStackLimiter
extends GuiTextButton {
    private static final int[] PRESETS = new int[]{1, 2, 4, 8, 16, 32, 48, 64};
    private final TileBlockExtender blockExtender;

    public GuiButtonStackLimiter(int x, int y, int width, int height, TileBlockExtender blockExtender) {
        super(x, y, width, height, "");
        this.blockExtender = blockExtender;
    }

    @Override
    public void actionPerformed(int mouseButton) {
        int limit = this.blockExtender.getStackLimiterLimit();
        int index = Arrays.binarySearch(PRESETS, limit);
        if (mouseButton == 0) {
            index = index < 0 ? Math.abs(index) - 1 : ++index;
        } else if (mouseButton == 1) {
            index = index < 0 ? Math.abs(index) - 2 : --index;
        }
        index = MathHelper.func_76125_a((int)index, (int)0, (int)(PRESETS.length - 1));
        this.blockExtender.setStackLimiterLimit(PRESETS[index]);
    }

    @Override
    public void mouseWheelMoved(int mouseX, int mouseY, int delta) {
        int limit = this.blockExtender.getStackLimiterLimit();
        if (delta > 0) {
            ++limit;
        } else if (delta < 0) {
            --limit;
        }
        limit = MathHelper.func_76125_a((int)limit, (int)1, (int)64);
        this.blockExtender.setStackLimiterLimit(limit);
    }

    @Override
    public void update() {
        super.update();
        this.text = String.valueOf(this.blockExtender.getStackLimiterLimit());
    }

    @Override
    public void addTooltip(List<String> list) {
        list.add(I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.stack_limiter", (Object[])new Object[0]));
        list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.stack_limiter_increase", (Object[])new Object[0]));
        list.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.stack_limiter_decrease", (Object[])new Object[0]));
    }
}

