/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.filter.IChecklistFilter;
import net.blay09.mods.refinedrelocation.client.ClientProxy;
import net.blay09.mods.refinedrelocation.client.gui.base.IParentScreen;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiElement;
import net.blay09.mods.refinedrelocation.client.util.TextureAtlasRegion;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class GuiChecklistEntry
extends GuiElement {
    private final IChecklistFilter filter;
    private final TextureAtlasRegion texture;
    private final TextureAtlasRegion textureChecked;
    private int currentOption = -1;

    public GuiChecklistEntry(IChecklistFilter filter) {
        this.filter = filter;
        this.setSize(151, 11);
        this.texture = ClientProxy.TEXTURE_ATLAS.getSprite("refinedrelocation:checklist");
        this.textureChecked = ClientProxy.TEXTURE_ATLAS.getSprite("refinedrelocation:checklist_checked");
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.currentOption != -1) {
            boolean oldState = this.filter.isOptionChecked(this.currentOption);
            this.filter.setOptionChecked(this.currentOption, !oldState);
            if (!oldState) {
                RefinedRelocationAPI.sendContainerMessageToServer("Check", this.currentOption);
            } else {
                RefinedRelocationAPI.sendContainerMessageToServer("Uncheck", this.currentOption);
            }
            return true;
        }
        return false;
    }

    @Override
    public void drawBackground(IParentScreen parentScreen, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(parentScreen, mouseX, mouseY, partialTicks);
        if (this.isInside(mouseX, mouseY)) {
            GuiChecklistEntry.func_73734_a((int)this.getAbsoluteX(), (int)this.getAbsoluteY(), (int)(this.getAbsoluteX() + this.getWidth()), (int)(this.getAbsoluteY() + this.getHeight()), (int)0x66FFFFFF);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currentOption != -1) {
            if (this.filter.isOptionChecked(this.currentOption)) {
                this.textureChecked.draw(this.getAbsoluteX() + 1, this.getAbsoluteY() + this.getHeight() / 2 - this.textureChecked.func_94216_b() / 2, this.field_73735_i);
            } else {
                this.texture.draw(this.getAbsoluteX() + 1, this.getAbsoluteY() + this.getHeight() / 2 - this.texture.func_94216_b() / 2, this.field_73735_i);
            }
            this.func_73731_b(parentScreen.getFontRenderer(), I18n.func_135052_a((String)this.filter.getOptionLangKey(this.currentOption), (Object[])new Object[0]), this.getAbsoluteX() + 14, this.getAbsoluteY() + this.getHeight() / 2 - parentScreen.getFontRenderer().field_78288_b / 2, 0xFFFFFF);
        }
    }

    public void setCurrentOption(int currentOption) {
        this.currentOption = currentOption;
    }
}

