/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import java.util.List;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.client.IFilterIcon;
import net.blay09.mods.refinedrelocation.api.filter.IChecklistFilter;
import net.blay09.mods.refinedrelocation.api.filter.IConfigurableFilter;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.client.ClientProxy;
import net.blay09.mods.refinedrelocation.client.gui.GuiAddFilter;
import net.blay09.mods.refinedrelocation.client.gui.GuiRootFilter;
import net.blay09.mods.refinedrelocation.client.gui.base.IParentScreen;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiElement;
import net.blay09.mods.refinedrelocation.client.util.TextureAtlasRegion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiFilterSlot
extends GuiElement {
    private final GuiRootFilter parentGui;
    private final TextureAtlasRegion texture;
    private final IRootFilter rootFilter;
    private final int index;

    public GuiFilterSlot(GuiRootFilter parentGui, IRootFilter rootFilter, int index) {
        this.parentGui = parentGui;
        this.rootFilter = rootFilter;
        this.index = index;
        this.texture = ClientProxy.TEXTURE_ATLAS.getSprite("refinedrelocation:filter_slot");
        this.setSize(this.texture.func_94211_a(), this.texture.func_94216_b());
    }

    @Override
    public void drawBackground(IParentScreen parentScreen, int mouseX, int mouseY, float partialTicks) {
        IFilterIcon filterIcon;
        super.drawBackground(parentScreen, mouseX, mouseY, partialTicks);
        this.texture.draw(this.getAbsoluteX(), this.getAbsoluteY(), this.field_73735_i);
        IFilter filter = this.rootFilter.getFilter(this.index);
        if (filter != null && (filterIcon = filter.getFilterIcon()) != null) {
            filterIcon.draw(this.getAbsoluteX(), this.getAbsoluteY(), 24.0, 24.0, this.field_73735_i);
        }
        if (parentScreen.getMouseElement() == this) {
            GuiFilterSlot.func_73734_a((int)(this.getAbsoluteX() + 1), (int)(this.getAbsoluteY() + 1), (int)(this.getAbsoluteX() + this.getWidth() - 1), (int)(this.getAbsoluteY() + this.getHeight() - 1), (int)-1711276033);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        IFilter filter = this.rootFilter.getFilter(this.index);
        if (filter == null) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAddFilter(this.parentGui));
        } else {
            RefinedRelocationAPI.sendContainerMessageToServer("EditFilter", this.index);
        }
        return true;
    }

    @Override
    public void addTooltip(List<String> list) {
        IFilter filter = this.rootFilter.getFilter(this.index);
        if (filter == null) {
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.no_filter_set", (Object[])new Object[0]));
            list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.click_to_add_filter", (Object[])new Object[0]));
        } else {
            list.add(I18n.func_135052_a((String)filter.getLangKey(), (Object[])new Object[0]));
            if (filter instanceof IConfigurableFilter || filter instanceof IChecklistFilter) {
                list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.click_to_configure", (Object[])new Object[0]));
            } else {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.not_configurable", (Object[])new Object[0]));
            }
        }
    }

    public int getFilterIndex() {
        return this.index;
    }

    public boolean hasFilter() {
        return this.rootFilter.getFilter(this.index) != null;
    }
}

