/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.compat.ironchest;

import cpw.mods.ironchest.common.blocks.chest.BlockIronChest;
import cpw.mods.ironchest.common.blocks.chest.IronChestType;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.block.BlockModTile;
import net.blay09.mods.refinedrelocation.compat.ironchest.TileSortingIronChest;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSortingIronChest
extends BlockModTile {
    public static final String name = "sorting_iron_chest";
    public static final ResourceLocation registryName = new ResourceLocation("refinedrelocation", "sorting_iron_chest");
    private Block delegateBlock;

    public BlockSortingIronChest() {
        super(Material.field_151573_f);
        this.func_149663_c(registryName.toString());
        this.func_149711_c(3.0f);
    }

    public void setDelegateBlock(Block delegateBlock) {
        this.delegateBlock = delegateBlock;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.delegateBlock.func_185496_a(state, source, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (player.func_70093_af() && (tileEntity = world.func_175625_s(pos)) instanceof TileSortingIronChest) {
            RefinedRelocationAPI.openRootFilterGui(player, tileEntity);
        }
        return this.delegateBlock.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((IronChestType)state.func_177229_b((IProperty)BlockIronChest.VARIANT_PROP)) {
            case GOLD: {
                return new TileSortingIronChest.Gold();
            }
            case DIAMOND: {
                return new TileSortingIronChest.Diamond();
            }
            case COPPER: {
                return new TileSortingIronChest.Copper();
            }
            case SILVER: {
                return new TileSortingIronChest.Silver();
            }
            case CRYSTAL: {
                return new TileSortingIronChest.Crystal();
            }
            case OBSIDIAN: {
                return new TileSortingIronChest.Obsidian();
            }
            case DIRTCHEST9000: {
                return new TileSortingIronChest.Dirt();
            }
        }
        return new TileSortingIronChest();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (IronChestType type : IronChestType.VALUES) {
            if (!type.isValidForCreativeMode()) continue;
            items.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockIronChest.VARIANT_PROP, (Comparable)IronChestType.VALUES[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((IronChestType)state.func_177229_b((IProperty)BlockIronChest.VARIANT_PROP)).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockIronChest.VARIANT_PROP});
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState blockState) {
        this.delegateBlock.func_176213_c(world, pos, blockState);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLiving, ItemStack itemStack) {
        this.delegateBlock.func_180633_a(world, pos, state, entityLiving, itemStack);
    }

    public int func_180651_a(IBlockState state) {
        return this.delegateBlock.func_180651_a(state);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.delegateBlock.func_180663_b(world, pos, state);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.delegateBlock.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean func_149740_M(IBlockState state) {
        return this.delegateBlock.func_149740_M(state);
    }

    @Override
    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return this.delegateBlock.func_180641_l(state, world, pos);
    }

    public EnumFacing[] getValidRotations(World worldObj, BlockPos pos) {
        return this.delegateBlock.getValidRotations(worldObj, pos);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return this.delegateBlock.rotateBlock(world, pos, axis);
    }
}

