/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.container;

import net.blay09.mods.refinedrelocation.RefinedRelocation;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.container.IContainerMessage;
import net.blay09.mods.refinedrelocation.container.ContainerMod;
import net.blay09.mods.refinedrelocation.network.MessageOpenGui;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.blay09.mods.refinedrelocation.util.RelativeSide;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerBlockExtender
extends ContainerMod {
    public static final String KEY_TOGGLE_SIDE = "ToggleSide";
    public static final String KEY_SIDE_INDEX = "SideIndex";
    public static final String KEY_SIDE_MAPPING = "SideMapping";
    public static final String KEY_STACK_LIMITER = "StackLimiter";
    public static final String KEY_CONFIGURE_FILTER = "ConfigureFilter";
    private final EntityPlayer player;
    private final TileBlockExtender tileEntity;
    private final EnumFacing[] lastSideMapping = new EnumFacing[5];
    private int lastStackLimiterLimit;

    public ContainerBlockExtender(EntityPlayer player, TileBlockExtender tileEntity) {
        this.player = player;
        this.tileEntity = tileEntity;
        for (int i = 0; i < 3; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileEntity.getItemHandlerUpgrades(), i, 152, 22 + i * 18));
        }
        this.addPlayerInventory(player, 94);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.lastSideMapping.length; ++i) {
            EnumFacing nowSideMapping = this.tileEntity.getSideMapping(RelativeSide.fromIndex(i));
            if (this.lastSideMapping[i] == nowSideMapping) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a(KEY_SIDE_INDEX, (byte)i);
            compound.func_74774_a(KEY_SIDE_MAPPING, nowSideMapping != null ? (byte)nowSideMapping.func_176745_a() : (byte)-1);
            RefinedRelocationAPI.syncContainerValue(KEY_SIDE_MAPPING, compound, (Iterable<IContainerListener>)this.field_75149_d);
            this.lastSideMapping[i] = nowSideMapping;
        }
        int nowStackLimiterLimit = this.tileEntity.getStackLimiterLimit();
        if (this.lastStackLimiterLimit != nowStackLimiterLimit) {
            RefinedRelocationAPI.syncContainerValue(KEY_STACK_LIMITER, this.tileEntity.getStackLimiterLimit(), (Iterable<IContainerListener>)this.field_75149_d);
            this.lastStackLimiterLimit = nowStackLimiterLimit;
        }
    }

    @Override
    public void receivedMessageServer(IContainerMessage message) {
        if (message.getKey().equals(KEY_TOGGLE_SIDE)) {
            RelativeSide side = RelativeSide.fromIndex(message.getIntValue());
            if (side != RelativeSide.FRONT) {
                int facingIdx = message.getSecondaryIntValue();
                EnumFacing facing = facingIdx == -1 ? null : EnumFacing.func_82600_a((int)facingIdx);
                this.tileEntity.setSideMapping(side, facing);
                this.lastSideMapping[side.ordinal()] = facing;
            }
        } else if (message.getKey().equals(KEY_STACK_LIMITER)) {
            int stackSizeLimit = MathHelper.func_76125_a((int)message.getIntValue(), (int)1, (int)64);
            this.tileEntity.setStackLimiterLimit(stackSizeLimit);
            this.lastStackLimiterLimit = stackSizeLimit;
        } else if (message.getKey().equals(KEY_CONFIGURE_FILTER)) {
            if (message.getIntValue() == 0 && !this.tileEntity.hasInputFilter()) {
                return;
            }
            if (message.getIntValue() == 1 && !this.tileEntity.hasOutputFilter()) {
                return;
            }
            RefinedRelocation.proxy.openGui(this.player, new MessageOpenGui(6, this.tileEntity.func_174877_v(), message.getIntValue()));
        }
    }

    @Override
    public void receivedMessageClient(IContainerMessage message) {
        if (message.getKey().equals(KEY_SIDE_MAPPING)) {
            NBTTagCompound compound = message.getNBTValue();
            this.tileEntity.setSideMapping(RelativeSide.fromIndex(compound.func_74771_c(KEY_SIDE_INDEX)), EnumFacing.func_82600_a((int)compound.func_74771_c(KEY_SIDE_MAPPING)));
        } else if (message.getKey().equals(KEY_STACK_LIMITER)) {
            this.tileEntity.setStackLimiterLimit(message.getIntValue());
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (index < 27 ? !this.func_75135_a(slotStack, 27, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return !this.tileEntity.func_145837_r() && player.func_70092_e((double)this.tileEntity.func_174877_v().func_177958_n() + 0.5, (double)this.tileEntity.func_174877_v().func_177956_o() + 0.5, (double)this.tileEntity.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public Slot getUpgradeSlot(int i) {
        return (Slot)this.field_75151_b.get(i);
    }
}

