/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.container;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.RefinedRelocation;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.container.IContainerMessage;
import net.blay09.mods.refinedrelocation.api.container.ReturnCallback;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.capability.CapabilityRootFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingInventory;
import net.blay09.mods.refinedrelocation.container.ContainerMod;
import net.blay09.mods.refinedrelocation.filter.FilterRegistry;
import net.blay09.mods.refinedrelocation.filter.RootFilter;
import net.blay09.mods.refinedrelocation.grid.SortingInventory;
import net.blay09.mods.refinedrelocation.network.MessageOpenGui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class ContainerRootFilter
extends ContainerMod {
    public static final String KEY_ROOT_FILTER = "RootFilter";
    public static final String KEY_ADD_FILTER = "AddFilter";
    public static final String KEY_EDIT_FILTER = "EditFilter";
    public static final String KEY_DELETE_FILTER = "DeleteFilter";
    public static final String KEY_PRIORITY = "Priority";
    public static final String KEY_BLACKLIST = "Blacklist";
    public static final String KEY_BLACKLIST_INDEX = "FilterIndex";
    private final EntityPlayer entityPlayer;
    private final TileEntity tileEntity;
    private final IRootFilter rootFilter;
    private ReturnCallback returnCallback;
    private ISortingInventory sortingInventory;
    private int lastFilterCount = -1;
    private int lastPriority;
    private final boolean[] lastBlacklist = new boolean[3];

    public ContainerRootFilter(EntityPlayer player, TileEntity tileEntity) {
        this(player, tileEntity, (IRootFilter)tileEntity.getCapability(CapabilityRootFilter.CAPABILITY, null));
    }

    public ContainerRootFilter(EntityPlayer player, TileEntity tileEntity, @Nullable IRootFilter rootFilter) {
        this.entityPlayer = player;
        this.tileEntity = tileEntity;
        if (rootFilter == null) {
            rootFilter = new RootFilter();
        }
        this.rootFilter = rootFilter;
        this.sortingInventory = (ISortingInventory)tileEntity.getCapability(CapabilitySortingInventory.CAPABILITY, null);
        this.addPlayerInventory(player, 128);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.rootFilter.getFilterCount() != this.lastFilterCount) {
            this.syncFilterList();
            RefinedRelocationAPI.updateFilterPreview(this.entityPlayer, this.tileEntity, this.rootFilter);
        }
        for (int i = 0; i < this.lastBlacklist.length; ++i) {
            boolean nowBlacklist = this.rootFilter.isBlacklist(i);
            if (this.lastBlacklist[i] == nowBlacklist) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a(KEY_BLACKLIST_INDEX, i);
            compound.func_74757_a(KEY_BLACKLIST, nowBlacklist);
            RefinedRelocationAPI.syncContainerValue(KEY_BLACKLIST, compound, (Iterable<IContainerListener>)this.field_75149_d);
            this.lastBlacklist[i] = nowBlacklist;
        }
        if (this.sortingInventory != null && this.sortingInventory.getPriority() != this.lastPriority) {
            RefinedRelocationAPI.syncContainerValue(KEY_PRIORITY, this.sortingInventory.getPriority(), (Iterable<IContainerListener>)this.field_75149_d);
            this.lastPriority = this.sortingInventory.getPriority();
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack itemStack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        RefinedRelocationAPI.updateFilterPreview(player, this.tileEntity, this.rootFilter);
        return itemStack;
    }

    private void syncFilterList() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74782_a(KEY_ROOT_FILTER, this.rootFilter.serializeNBT());
        RefinedRelocationAPI.syncContainerValue(KEY_ROOT_FILTER, tagCompound, (Iterable<IContainerListener>)this.field_75149_d);
        this.lastFilterCount = this.rootFilter.getFilterCount();
        for (int i = 0; i < this.lastBlacklist.length; ++i) {
            this.lastBlacklist[i] = this.rootFilter.isBlacklist(i);
        }
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (index < 27 ? !this.func_75135_a(slotStack, 27, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    @Override
    public void receivedMessageServer(IContainerMessage message) {
        if (message.getKey().equals(KEY_ADD_FILTER)) {
            String typeId = message.getStringValue();
            IFilter filter = FilterRegistry.createFilter(typeId);
            if (filter == null) {
                return;
            }
            if (this.rootFilter.getFilterCount() >= 3) {
                return;
            }
            this.rootFilter.addFilter(filter);
            this.tileEntity.func_70296_d();
            this.lastFilterCount = this.rootFilter.getFilterCount();
            this.syncFilterList();
            RefinedRelocationAPI.updateFilterPreview(this.entityPlayer, this.tileEntity, this.rootFilter);
            RefinedRelocation.proxy.openGui(this.entityPlayer, new MessageOpenGui(3, this.tileEntity.func_174877_v(), this.rootFilter.getFilterCount() - 1));
        } else if (message.getKey().equals(KEY_EDIT_FILTER)) {
            int index = message.getIntValue();
            if (index < 0 || index >= this.rootFilter.getFilterCount()) {
                return;
            }
            IFilter filter = this.rootFilter.getFilter(index);
            if (filter != null) {
                RefinedRelocation.proxy.openGui(this.entityPlayer, new MessageOpenGui(3, this.tileEntity.func_174877_v(), index));
            }
        } else if (message.getKey().equals(KEY_DELETE_FILTER)) {
            int index = message.getIntValue();
            if (index < 0 || index >= this.rootFilter.getFilterCount()) {
                return;
            }
            this.rootFilter.removeFilter(index);
            this.tileEntity.func_70296_d();
        } else if (message.getKey().equals(KEY_PRIORITY)) {
            int value = message.getIntValue();
            if (value < -999 || value > 999) {
                return;
            }
            if (this.sortingInventory == null) {
                return;
            }
            this.sortingInventory.setPriority(value);
            this.tileEntity.func_70296_d();
        } else if (message.getKey().equals(KEY_BLACKLIST)) {
            NBTTagCompound tagCompound = message.getNBTValue();
            int index = tagCompound.func_74762_e(KEY_BLACKLIST_INDEX);
            if (index < 0 || index >= this.rootFilter.getFilterCount()) {
                return;
            }
            this.rootFilter.setIsBlacklist(index, tagCompound.func_74767_n(KEY_BLACKLIST));
            this.tileEntity.func_70296_d();
            RefinedRelocationAPI.updateFilterPreview(this.entityPlayer, this.tileEntity, this.rootFilter);
        }
    }

    @Override
    public void receivedMessageClient(IContainerMessage message) {
        if (message.getKey().equals(KEY_ROOT_FILTER)) {
            this.rootFilter.deserializeNBT((NBTBase)message.getNBTValue().func_74775_l(KEY_ROOT_FILTER));
        } else if (message.getKey().equals(KEY_PRIORITY)) {
            this.getSortingInventory().setPriority(message.getIntValue());
        } else if (message.getKey().equals(KEY_BLACKLIST)) {
            NBTTagCompound compound = message.getNBTValue();
            this.rootFilter.setIsBlacklist(compound.func_74762_e(KEY_BLACKLIST_INDEX), compound.func_74767_n(KEY_BLACKLIST));
        }
    }

    public IRootFilter getRootFilter() {
        return this.rootFilter;
    }

    public ISortingInventory getSortingInventory() {
        if (this.sortingInventory == null) {
            this.sortingInventory = new SortingInventory();
        }
        return this.sortingInventory;
    }

    @Nullable
    public ReturnCallback getReturnCallback() {
        return this.returnCallback;
    }

    public ContainerRootFilter setReturnCallback(@Nullable ReturnCallback returnCallback) {
        this.returnCallback = returnCallback;
        return this;
    }
}

