/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.filter;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import net.blay09.mods.refinedrelocation.api.client.IFilterIcon;
import net.blay09.mods.refinedrelocation.api.filter.IChecklistFilter;
import net.blay09.mods.refinedrelocation.client.ClientProxy;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModFilter
implements IChecklistFilter {
    public static final String ID = "refinedrelocation:mod_filter";
    private static final Map<String, ModWithName> modList = Maps.newHashMap();
    public static String[] modIds = new String[0];
    private final boolean[] modStates = new boolean[modIds.length];

    public static void gatherMods() {
        HashSet modSet = Sets.newHashSet();
        for (ResourceLocation registryName : Item.field_150901_e.func_148742_b()) {
            modSet.add(registryName.func_110624_b());
        }
        String[] unsorted = modSet.toArray(new String[modSet.size()]);
        Arrays.sort(unsorted, (o1, o2) -> {
            if (o1.equals("minecraft")) {
                return -1;
            }
            if (o2.equals("minecraft")) {
                return 1;
            }
            return o2.compareTo((String)o1);
        });
        ModFilter.setModList(unsorted);
    }

    public static void setModList(String[] modIDs) {
        modIds = modIDs;
        Map mods = Loader.instance().getIndexedModList();
        modList.clear();
        for (int i = 0; i < modIDs.length; ++i) {
            if (modIDs[i].equals("minecraft")) {
                modList.put(modIDs[i], new ModWithName(i, modIDs[i], "Minecraft"));
                continue;
            }
            ModContainer modContainer = (ModContainer)mods.get(modIDs[i]);
            modList.put(modIDs[i], new ModWithName(i, modIDs[i], modContainer != null ? modContainer.getName() : modIDs[i]));
        }
    }

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public boolean isFilterUsable(TileEntity tileEntity) {
        return true;
    }

    @Override
    public boolean passes(TileEntity tileEntity, ItemStack itemStack) {
        ResourceLocation resourceLocation = itemStack.func_77973_b().getRegistryName();
        if (resourceLocation != null) {
            ModWithName modWithName = modList.get(resourceLocation.func_110624_b());
            return modWithName != null && this.modStates[modWithName.getIndex()];
        }
        return false;
    }

    public NBTBase serializeNBT() {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.modStates.length; ++i) {
            if (!this.modStates[i]) continue;
            list.func_74742_a((NBTBase)new NBTTagString(modIds[i]));
        }
        return list;
    }

    public void deserializeNBT(NBTBase nbt) {
        NBTTagList list = (NBTTagList)nbt;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            String modId = list.func_150307_f(i);
            for (int j = 0; j < modIds.length; ++j) {
                if (!modIds[j].equals(modId)) continue;
                this.modStates[j] = true;
            }
        }
    }

    @Override
    public String getLangKey() {
        return "filter.refinedrelocation:mod_filter";
    }

    @Override
    public String getDescriptionLangKey() {
        return "filter.refinedrelocation:mod_filter.description";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IFilterIcon getFilterIcon() {
        return ClientProxy.TEXTURE_ATLAS.getSprite("refinedrelocation:icon_mod_filter");
    }

    @Override
    public String getOptionLangKey(int option) {
        return modList.get(modIds[option]).getName();
    }

    @Override
    public void setOptionChecked(int option, boolean checked) {
        this.modStates[option] = checked;
    }

    @Override
    public boolean isOptionChecked(int option) {
        return this.modStates[option];
    }

    @Override
    public int getOptionCount() {
        return modIds.length;
    }

    @Override
    public int getVisualOrder() {
        return 800;
    }

    private static class ModWithName {
        private final int index;
        private final String id;
        private final String name;

        public ModWithName(int index, String id, String name) {
            this.index = index;
            this.id = id;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

